/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widget.IWidget;
import tv.soaryn.xycraft.core.ui.widget.WidgetState;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ButtonWidget
implements IWidget.Foreground {
    private IWidget.Data _data;
    private final TextureAtlas _textureAtlas;
    private final NineSlicedResource _window;
    private final TextureAtlasSprite _cloudFXSprite;
    private final ColorSource _color;
    private Function<ButtonWidget, Boolean> OnClick;
    private ContainerData _stateSource;
    private int _stateIndex;
    private int _buttonIndex;

    public ButtonWidget(BaseMenuUI<?> ui, NineSlicedResource resource, float x, float y, float width, float height, ColorSource color) {
        this._data = new IWidget.Data(ui);
        this._data.Dimensions = new Rectangle(x, y, resource.getMinWidth(width), resource.getMinHeight(height));
        this._textureAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
        this._window = resource;
        this._color = color;
        this._cloudFXSprite = this._textureAtlas.m_118316_(new ResourceLocation("xycraft_core", "block/cloudfx"));
    }

    public ButtonWidget setStateSource(ContainerData menuData, int index, int buttonIndex) {
        this._stateSource = menuData;
        this._stateIndex = index;
        this._buttonIndex = buttonIndex;
        return this;
    }

    public ButtonWidget setOnClick(Function<ButtonWidget, Boolean> action) {
        this.OnClick = action;
        return this;
    }

    public boolean setState(WidgetState state) {
        if (state == this._data.State) {
            return false;
        }
        this._data.State = state;
        return true;
    }

    @Override
    @NotNull
    public IWidget.Data getData() {
        return this._data;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Vector3f rgb;
        if (this._stateSource != null) {
            rgb = this._data.IsMouseOver && this._stateSource.m_6413_(this._stateIndex) != this._buttonIndex ? ColorUtils.convertRGBToComponents(-16711936) : ColorUtils.convertRGBToComponents(this._color.getColor());
            if (!this._data.IsMouseOver && this._stateSource.m_6413_(this._stateIndex) != this._buttonIndex) {
                rgb = rgb.mul(0.1f, 0.1f, 0.1f);
            }
        } else {
            rgb = this._data.IsMouseOver && this._data.State != WidgetState.Active ? ColorUtils.convertRGBToComponents(-16711936) : ColorUtils.convertRGBToComponents(this._color.getColor());
            if (!this._data.IsMouseOver && this._data.State == WidgetState.Idle) {
                rgb = rgb.mul(0.1f, 0.1f, 0.1f);
            }
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._textureAtlas.m_118330_());
        RenderSystem.setShaderColor((float)rgb.x, (float)rgb.y, (float)rgb.z, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 4.0f, 0.0f);
        TiledIcon.render(poseStack, this._data.Dimensions.x() + 4.0f, this._data.Dimensions.y() + 4.0f, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f, 1.0f, this._cloudFXSprite, new TiledIcon.TileConfiguration(false, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f));
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.25f);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("xycraft_core", "textures/gui/hex.png"));
        RenderSystem.enableBlend();
        TiledIcon.render(poseStack, this._data.Dimensions.x() + 4.0f, this._data.Dimensions.y() + 4.0f, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f, 0.125f, 0.0f, 1.0f, 0.0f, 1.0f, 256, 256, new TiledIcon.TileConfiguration(true, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f));
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this._window.render(poseStack, 0.0f, 0.0f, (int)this._data.Dimensions.width(), (int)this._data.Dimensions.height(), 1.0f);
        poseStack.m_85849_();
    }

    @Override
    public boolean onMouseDown(double x, double y, int button) {
        if (this.OnClick == null) {
            return false;
        }
        return this.OnClick.apply(this);
    }
}

