/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TiledIcon {
    public static void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale, @NotNull TextureAtlasSprite sprite, TileConfiguration configuration) {
        SpriteContents spriteContents = sprite.m_245424_();
        TiledIcon.render(matrixStack, x, y, width, height, scale, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), spriteContents.m_246492_(), spriteContents.m_245330_(), configuration);
    }

    public static void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale, float spriteU0, float spriteU1, float spriteV0, float spriteV1, int spriteWidth, int spriteHeight, TileConfiguration configuration) {
        int yCoord;
        int xCoord;
        int i;
        float invScale = 1.0f / scale;
        int tileX = (int)(width * invScale / (float)spriteWidth);
        int tileY = (int)(height * invScale / (float)spriteHeight);
        float modWidth = width * invScale % (float)spriteWidth;
        float modHeight = height * invScale % (float)spriteHeight;
        matrixStack.m_85836_();
        if (!configuration.reverse) {
            matrixStack.m_252880_(configuration.maxWidth, configuration.maxHeight, 0.0f);
        }
        matrixStack.m_85841_(configuration.reverse ? scale : -scale, configuration.reverse ? scale : -scale, scale);
        float u = 16.0f * modWidth / (float)spriteWidth;
        float v = 16.0f * modHeight / (float)spriteHeight;
        if (!configuration.reverse) {
            u = 16.0f - u;
            v = 16.0f - v;
        }
        float u0 = configuration.reverse ? spriteU0 : spriteU1;
        float u1 = configuration.reverse ? spriteU1 : spriteU0;
        float v0 = configuration.reverse ? spriteV0 : spriteV1;
        float v1 = configuration.reverse ? spriteV1 : spriteV0;
        boolean offset = false;
        for (i = 0; i < tileX; ++i) {
            for (int j = 0; j < tileY; ++j) {
                int xCoord2 = i * spriteWidth;
                int yCoord2 = j * spriteHeight;
                int xCoordWidth = xCoord2 + spriteWidth;
                int yCoordHeight = yCoord2 + spriteHeight;
                TiledIcon.innerBlit(matrixStack.m_85850_().m_252922_(), (float)xCoord2, (float)xCoordWidth, (float)yCoord2, (float)yCoordHeight, (float)offset, u0, u1, v0, v1);
            }
        }
        u1 = configuration.reverse ? spriteU1 : spriteU0;
        v1 = spriteV0 + (spriteV1 - spriteV0) * v / 16.0f;
        for (i = 0; i < tileX; ++i) {
            xCoord = i * spriteWidth;
            yCoord = tileY * spriteHeight;
            int xCoordWidth = xCoord + spriteWidth;
            float yCoordHeight = (float)yCoord + modHeight;
            TiledIcon.innerBlit(matrixStack.m_85850_().m_252922_(), (float)xCoord, (float)xCoordWidth, (float)yCoord, yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        u1 = spriteU0 + (spriteU1 - spriteU0) * u / 16.0f;
        v1 = configuration.reverse ? spriteV1 : spriteV0;
        for (int j = 0; j < tileY; ++j) {
            xCoord = tileX * spriteWidth;
            yCoord = j * spriteHeight;
            float xCoordWidth = (float)xCoord + modWidth;
            int yCoordHeight = yCoord + spriteHeight;
            TiledIcon.innerBlit(matrixStack.m_85850_().m_252922_(), (float)xCoord, xCoordWidth, (float)yCoord, (float)yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        int xCoord3 = tileX * spriteWidth;
        int yCoord3 = tileY * spriteHeight;
        float xCoordWidth = (float)xCoord3 + modWidth;
        float yCoordHeight = (float)yCoord3 + modHeight;
        u1 = spriteU0 + (spriteU1 - spriteU0) * u / 16.0f;
        v1 = spriteV0 + (spriteV1 - spriteV0) * v / 16.0f;
        TiledIcon.innerBlit(matrixStack.m_85850_().m_252922_(), (float)xCoord3, xCoordWidth, (float)yCoord3, yCoordHeight, (float)offset, u0, u1, v0, v1);
        matrixStack.m_85849_();
    }

    public static void innerBlit(@NotNull PoseStack matrixStack, float x0, float x1, float y0, float y1, float offset, float u0, float u1, float v0, float v1) {
        TiledIcon.innerBlit(matrixStack.m_85850_().m_252922_(), x0, x1, y0, y1, offset, u0, u1, v0, v1);
    }

    public static void innerBlit(Matrix4f matrix, float x0, float x1, float y0, float y1, float zOffset, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x0, y1, zOffset).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y1, zOffset).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y0, zOffset).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_252986_(matrix, x0, y0, zOffset).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public record TileConfiguration(boolean reverse, float maxWidth, float maxHeight) {
        public TileConfiguration() {
            this(true, 0.0f, 0.0f);
        }
    }
}

