/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;

public final class NetworkHandler {
    private final SimpleChannel channel;

    private NetworkHandler(SimpleChannel channel) {
        this.channel = channel;
    }

    public void send(Packet.ServerBound packet) {
        this.channel.sendToServer((Object)packet);
    }

    public void send(Player player, Packet.ClientBound packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalArgumentException("The player must be a ServerPlayer.");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
    }

    public void broadcast(Packet.ClientBound packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void broadcast(Level level, Packet.ClientBound packet) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("The level must be a ServerLevel.");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.channel.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)serverLevel).m_46472_()), (Object)packet);
    }

    public void broadcast(Level level, ChunkPos pos, Packet.ClientBound packet) {
        if (!level.m_46749_(pos.m_45615_())) {
            return;
        }
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_6325_(pos.f_45578_, pos.f_45579_)), (Object)packet);
    }

    public void broadcast(Level level, BlockPos pos, Packet.ClientBound packet) {
        if (!level.m_46749_(pos)) {
            return;
        }
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)packet);
    }

    public static Builder builder(String domain, String path, int version) {
        return NetworkHandler.builder(new ResourceLocation(domain, path), version);
    }

    public static Builder builder(ResourceLocation name, int version) {
        return new Builder(name, version);
    }

    public static final class Builder {
        private final SimpleChannel channel;
        private final NetworkHandler networkHandler;
        private int id = 0;

        public Builder(ResourceLocation name, int version) {
            String versionString = "" + version;
            this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> versionString, v -> versionString.equals(v), v -> versionString.equals(v));
            this.networkHandler = new NetworkHandler(this.channel);
        }

        public <T extends Packet> Builder register(Class<T> packet, BinarySerializer<T> serdes) {
            this.channel.messageBuilder(packet, this.id++).encoder(serdes::serialize).decoder(serdes::deserialize).consumerNetworkThread((msg, ctx) -> {
                if (msg instanceof Packet.ClientBound) {
                    Packet.ClientBound clientbound = (Packet.ClientBound)msg;
                    clientbound.handle(new Context.Client(this.networkHandler, (Supplier<NetworkEvent.Context>)ctx));
                    return true;
                }
                if (msg instanceof Packet.ServerBound) {
                    Packet.ServerBound serverbound = (Packet.ServerBound)msg;
                    serverbound.handle(new Context.Server(this.networkHandler, (Supplier<NetworkEvent.Context>)ctx));
                    return true;
                }
                return false;
            }).add();
            return this;
        }

        public NetworkHandler build() {
            return this.networkHandler;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static abstract class Context
        implements Packet.Context {
            protected final NetworkHandler networkHandler;
            protected final Supplier<NetworkEvent.Context> eventContext;

            private Context(NetworkHandler networkHandler, Supplier<NetworkEvent.Context> eventContext) {
                this.networkHandler = networkHandler;
                this.eventContext = eventContext;
            }

            @Override
            public NetworkHandler networkHandler() {
                return this.networkHandler;
            }

            @Override
            public void enqueueMainThread(Runnable runnable) {
                this.eventContext.get().enqueueWork(runnable);
            }

            private static final class Server
            extends Context
            implements Packet.ServerBound.Context {
                private Server(NetworkHandler networkHandler, Supplier<NetworkEvent.Context> eventContext) {
                    super(networkHandler, eventContext);
                }

                @Override
                public ServerPlayer player() {
                    return ((NetworkEvent.Context)this.eventContext.get()).getSender();
                }
            }

            private static final class Client
            extends Context
            implements Packet.ClientBound.Context {
                private Client(NetworkHandler networkHandler, Supplier<NetworkEvent.Context> eventContext) {
                    super(networkHandler, eventContext);
                }

                @Override
                public Player player() {
                    return Utils.getClientPlayer();
                }
            }
        }
    }
}

