/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities.player;

import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.CoreCapabilities;
import tv.soaryn.xycraft.core.content.CustomColors;

@AutoRegisterCapability
public interface ColorCapability
extends ICapabilityProvider,
INBTSerializable<IntTag> {
    public static int colorOf(Player player) {
        return player.getCapability(CoreCapabilities.Player.Color).map(ColorCapability::getColor).orElse(CustomColors.Blue.getColor());
    }

    public static void use(Player player, IUseColorCapability use) {
        player.getCapability(CoreCapabilities.Player.Color).resolve().ifPresent(use::handle);
    }

    public int getColor();

    public void setColor(int var1);

    @FunctionalInterface
    public static interface IUseColorCapability {
        public void handle(ColorCapability var1);
    }

    public static class Handle
    implements ColorCapability {
        private final LazyOptional<ColorCapability> optional = LazyOptional.of(() -> this);
        private int _color = CustomColors.Blue.getColor();

        @Override
        public int getColor() {
            return this._color;
        }

        @Override
        public void setColor(int color) {
            this._color = color;
        }

        public IntTag serializeNBT() {
            return IntTag.m_128679_((int)this.getColor());
        }

        public void deserializeNBT(IntTag nbt) {
            this.setColor(nbt.m_7047_());
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CoreCapabilities.Player.Color.orEmpty(cap, this.optional.cast());
        }
    }
}

