/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ColoredBlock
extends XyBlock
implements IColored {
    protected final ColorSource _colorSource;
    protected final MapColor mapColor;
    private static final MapColor[] colorPool = new MapColor[]{MapColor.f_283811_, MapColor.f_283750_, MapColor.f_283931_, MapColor.f_283869_, MapColor.f_283832_, MapColor.f_283916_, MapColor.f_283765_, MapColor.f_283818_, MapColor.f_283779_, MapColor.f_283772_, MapColor.f_283889_, MapColor.f_283743_, MapColor.f_283748_, MapColor.f_283784_, MapColor.f_283913_, MapColor.f_283927_};

    public ColoredBlock(ColorSource color, BlockBehaviour.Properties properties) {
        super(properties);
        this._colorSource = color;
        this.mapColor = ColoredBlock.getClosestMaterialColor(color.getColor());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)));
    }

    public static MapColor getClosestMaterialColor(int color) {
        MapColor closest = MapColor.f_283808_;
        double currentDif = 2.147483647E9;
        Vector3f colorVec = ColorUtils.convertRGBToComponents(color);
        for (MapColor materialColor : colorPool) {
            Vector3f materialColorVec = ColorUtils.convertRGBToComponents(materialColor.f_283871_);
            double distance = colorVec.distance((Vector3fc)materialColorVec);
            if (!(distance < currentDif)) continue;
            currentDif = distance;
            closest = materialColor;
        }
        return closest;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return this.mapColor;
    }

    public static Supplier<Block> supplier(ColorSource color) {
        return () -> new ColoredBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60918_(SoundType.f_154654_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_()));
    }

    public static Supplier<Block> supplier() {
        return ColoredBlock.supplier(new ColorSource.Arbitrary(-1));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CoreStateProperties.Spawnable});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns(state, level, pos, player, interactionHand);
        return interactionResult != InteractionResult.PASS ? interactionResult : super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public static InteractionResult tryToAllowSpawns(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_41720_() == Items.f_42784_ && !((Boolean)state.m_61143_((Property)CoreStateProperties.Spawnable)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, stack);
            }
            BlockState spawnableBlockState = (BlockState)state.m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(true));
            stack.m_41774_(player.m_7500_() ? 0 : 1);
            level.m_7731_(pos, spawnableBlockState, 11);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)spawnableBlockState));
            level.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return entityType == EntityType.f_20532_ || (Boolean)state.m_61143_((Property)CoreStateProperties.Spawnable) != false;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int getColorOfItem(ItemStack stack, int index) {
        return index == -1 ? -1 : this._colorSource.getColor();
    }
}

