/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.items.XyItem;

public class ItemContent
implements IContent<ItemContent>,
ItemLike {
    private final RegistryObject<Item> _registryItem;
    private String _modelPath;
    private final HashMap<String, String> _localizations = new HashMap();
    private boolean _customItemModel;
    private RegistryObject<CreativeModeTab> _tab;
    boolean hasToolTip;

    public ItemContent(RegistryObject<Item> item) {
        this._registryItem = item;
        this._modelPath = item.getId().m_135815_();
        this._localizations.put("en_us", item.getId().m_135815_());
    }

    public ItemContent withTempModel() {
        return this.withModelPath("temp");
    }

    public ItemContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    @Override
    public ItemContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public ItemContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public ResourceLocation id() {
        return this._registryItem.getId();
    }

    public Item item() {
        return (Item)this._registryItem.get();
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public ItemContent enableToolTip(int count) {
        this.hasToolTip = true;
        return this;
    }

    @Override
    public RegistryObject<CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public ItemContent setTab(RegistryObject<CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    @Override
    public void setToolTip() {
        Item item;
        if (this.hasToolTip && (item = this.item()) instanceof XyItem) {
            XyItem item2 = (XyItem)item;
            item2.addToolTip((Component)Component.m_237115_((String)("item.xycraft_machines." + this.id().m_135815_() + ".tooltip")));
        }
    }

    @NotNull
    public Item m_5456_() {
        return this.item();
    }
}

