/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import tv.soaryn.xycraft.core.content.IContent;

public class FluidContent
implements IContent<FluidContent> {
    public final RegistryObject<ForgeFlowingFluid.Source> Source;
    public final RegistryObject<ForgeFlowingFluid.Flowing> Flowing;
    public final RegistryObject<FluidType> Type;
    public final ForgeFlowingFluid.Properties FluidProperties;
    private String _modelPath;
    protected final HashMap<String, String> _localizations = new HashMap();
    private RegistryObject<CreativeModeTab> _tab;

    public FluidContent(String name, DeferredRegister<Fluid> fluidMap, DeferredRegister<FluidType> fluitTypeMap, Supplier<FluidType> type, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> source, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowing, Consumer<ForgeFlowingFluid.Properties> fluidProperties) {
        this.Type = fluitTypeMap.register(name, type);
        this.Source = fluidMap.register(name, () -> (ForgeFlowingFluid.Source)source.apply(this.getFluidProperties()));
        this.Flowing = fluidMap.register("flowing_" + name, () -> (ForgeFlowingFluid.Flowing)flowing.apply(this.getFluidProperties()));
        this.FluidProperties = new ForgeFlowingFluid.Properties(this.Type, this.Source, this.Flowing);
        if (fluidProperties != null) {
            fluidProperties.accept(this.FluidProperties);
        }
        this._localizations.put("en_us", this.Source.getId().m_135815_());
    }

    public ForgeFlowingFluid.Properties getFluidProperties() {
        return this.FluidProperties;
    }

    @Override
    public ResourceLocation id() {
        return this.Type.getId();
    }

    @Override
    public FluidContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public FluidContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public RegistryObject<CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public FluidContent setTab(RegistryObject<CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }
}

