/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.config;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import tv.soaryn.xycraft.core.utils.IRegister;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreConfig
implements IRegister {
    public static final CoreConfig Instance = new CoreConfig();
    public static final ForgeConfigSpec ClientConfigs;
    public static ForgeConfigSpec.BooleanValue ShowItemTags;
    public static ForgeConfigSpec.BooleanValue ShowReloadMessage;
    public static ForgeConfigSpec.DoubleValue UIInterpolationSpeed;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Used primarily for debugging or pack creation. May not be ideal to have turned on when playing the game");
        builder.push("Debug Settings");
        ShowItemTags = builder.comment("Show item tags in the tooltip of an item, when using advanced tooltips (F3 + h).").define("show_item_tags", false);
        ShowReloadMessage = builder.comment("Play a ding and print a message upon successful reload").define("show_reload_message", true);
        UIInterpolationSpeed = builder.comment("How fast a ui should change states each tick (example between two colors)").defineInRange("ui_interpolation_speed", 0.25, 0.001, 1.0);
        builder.pop();
    }

    @Override
    public void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("xycraft"));
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigs, "xycraft/core_client.toml");
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        CoreConfig.setupConfig(configBuilder);
        ClientConfigs = configBuilder.build();
    }
}

