/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render.texture;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Random;

public class CloudFX
extends TextureAtlasSprite {
    SpriteTicker _ticker = new SpriteTicker(this.m_245424_());
    public int frameTime = 60;

    protected CloudFX(ResourceLocation loc, SpriteContents contents, int width, int height, int x, int y) {
        super(loc, contents, width, height, x, y);
    }

    @Nullable
    public TextureAtlasSprite.Ticker m_247406_() {
        return new TextureAtlasSprite.Ticker(){

            public void m_245385_() {
                CloudFX.this._ticker.m_247697_(CloudFX.this.m_174743_(), CloudFX.this.m_174744_());
            }

            public void close() {
                CloudFX.this._ticker.close();
            }
        };
    }

    public void m_118416_() {
        NativeImage image = this._ticker._contents.getOriginalImage();
        for (int i = 0; i < 128; ++i) {
            this._ticker.generateImage(image);
        }
        this._ticker.m_247697_(this.m_174743_(), this.m_174744_());
    }

    public static class SpriteTicker
    implements net.minecraft.client.renderer.texture.SpriteTicker {
        float[] red;
        float[] green;
        float[] blue;
        float[] alpha;
        byte alphaByte;
        private final SpriteContents _contents;

        public SpriteTicker(SpriteContents contents) {
            this._contents = contents;
            int squaredSize = this._contents.m_246492_() * this._contents.m_245330_();
            this.red = new float[squaredSize];
            this.green = new float[squaredSize];
            this.blue = new float[squaredSize];
            this.alpha = new float[squaredSize];
            this.alphaByte = this._contents.getOriginalImage().m_85087_(0, 0);
        }

        public void m_247697_(int jim, int bob) {
            this.generateImage(this._contents.getOriginalImage());
            for (int mip = 0; mip < this._contents.f_243731_.length; ++mip) {
                if (this._contents.m_246492_() >> mip <= 0 || this._contents.m_245330_() >> mip <= 0) continue;
                NativeImage nativeImage = this._contents.f_243731_[mip];
                for (int x = 0; x < nativeImage.m_84982_(); ++x) {
                    for (int y = 0; y < nativeImage.m_85084_(); ++y) {
                        nativeImage.m_84988_(x, y, this._contents.getOriginalImage().m_84985_(x << mip, y << mip));
                    }
                }
                nativeImage.m_85003_(mip, jim >> mip, bob >> mip, 0, 0, this._contents.m_246492_() >> mip, this._contents.m_245330_() >> mip, this._contents.f_243731_.length > 1, false);
            }
        }

        public void close() {
        }

        public void generateImage(NativeImage image) {
            int tileSizeBase = image.m_84982_();
            this.evolveNoise(tileSizeBase, tileSizeBase - 1);
            int alphaShifted = (this.alphaByte & 0xFF) << 24;
            for (int x = 0; x < tileSizeBase; ++x) {
                for (int y = 0; y < tileSizeBase; ++y) {
                    float v = this.red[x + tileSizeBase * y];
                    int intensity = (int)(Mth.m_14036_((float)(v * 1.5f), (float)0.1f, (float)1.0f) * 255.0f) & 0xFF;
                    int rgba = 65793 * intensity | alphaShifted;
                    image.m_84988_(x, y, rgba);
                }
            }
        }

        private void evolveNoise(int tileSizeBase, int tileSizeMask) {
            for (int x = 0; x < tileSizeBase; ++x) {
                for (int y = 0; y < tileSizeBase; ++y) {
                    Random rand;
                    int col = x & tileSizeMask;
                    int colAdj = x + 1 & tileSizeMask;
                    int row = (y & tileSizeMask) * tileSizeBase;
                    int rowAdj = (y + 1 & tileSizeMask) * tileSizeBase;
                    int pixelIndex = row + col;
                    float redModifier = -0.0215f;
                    for (int k = x - 1; k <= x + 1; ++k) {
                        for (int l = y - 1; l <= y + 1; ++l) {
                            redModifier += this.red[(k & tileSizeMask) + (l & tileSizeMask) * tileSizeBase];
                        }
                    }
                    float blueAverage = (this.blue[pixelIndex] + this.blue[colAdj + row] + this.blue[colAdj + rowAdj] + this.blue[col + rowAdj]) * 0.25f;
                    this.green[pixelIndex] = redModifier * 0.1005f + blueAverage;
                    int n = pixelIndex;
                    this.blue[n] = this.blue[n] + this.alpha[pixelIndex] * 0.0108f;
                    float amount = 0.0425f;
                    float factor = 0.1f;
                    int n2 = pixelIndex;
                    this.alpha[n2] = this.alpha[n2] - amount;
                    if (this.blue[pixelIndex] < 0.0f) {
                        this.blue[pixelIndex] = 0.0f;
                    }
                    if ((rand = new Random()).nextFloat() >= 0.0065f) continue;
                    this.alpha[pixelIndex] = 1.0f;
                }
            }
            float[] greenTemp = this.green;
            this.green = this.red;
            this.red = greenTemp;
        }
    }
}

