/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class FluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.m_6299_(RenderType.m_110469_());
    }

    public static void renderFluidStream(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int color, int light, boolean renderBottom) {
        FluidRenderer.renderFluidStream(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, color, light, renderBottom);
    }

    public static void renderFluidStream(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack poseStack, int color, int light, boolean renderBottom) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)atlas.apply(clientFluid.getStillTexture(fluidStack));
        TextureAtlasSprite flowingTexture = (TextureAtlasSprite)atlas.apply(clientFluid.getFlowingTexture(fluidStack));
        int src = -1;
        int dst = color;
        color = 0;
        for (int i = 0; i < 32; i += 8) {
            color |= ((src >> i & 0xFF) * (dst >> i & 0xFF) / 255 & 0xFF) << i;
        }
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        poseStack.m_85836_();
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    FluidRenderer.renderFlowingTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, poseStack, light, color, flowingTexture);
                    continue;
                }
                FluidRenderer.renderFlowingTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, poseStack, light, color, flowingTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, poseStack, light, color, stillTexture);
        }
        poseStack.m_85849_();
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int color, int light, boolean renderBottom) {
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, color, light, renderBottom);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack poseStack, int color, int light, boolean renderBottom) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int src = -1;
        int dst = color;
        color = 0;
        for (int i = 0; i < 32; i += 8) {
            color |= ((src >> i & 0xFF) * (dst >> i & 0xFF) / 255 & 0xFF) << i;
        }
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        poseStack.m_85836_();
        poseStack.m_85837_(center.m_7096_(), center.m_7098_(), center.m_7094_());
        poseStack.m_252781_(new Quaternionf().rotationX((float)Math.PI));
        poseStack.m_85837_(-center.m_7096_(), -center.m_7098_(), -center.m_7094_());
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, poseStack, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, poseStack, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, poseStack, light, color, fluidTexture);
        }
        poseStack.m_85849_();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderFlowingTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.5f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f * textureScale;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f * textureScale;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f * textureScale));
            } else {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f * textureScale));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }
}

