/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.network.packets.CBColorSyncPacket;

@Mod.EventBusSubscriber(modid="xycraft_core", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class XyCoreCommon {
    @SubscribeEvent
    public static void onAttachCapabilitiesToPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(new ResourceLocation("xycraft_core", "modifier_key_capability"), (ICapabilityProvider)new ModifierKeyCapability.Handle());
        event.addCapability(new ResourceLocation("xycraft_core", "color_capability"), (ICapabilityProvider)new ColorCapability.Handle());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        int color = ColorCapability.colorOf(player);
        XyCore.Network.broadcast(new CBColorSyncPacket(player.m_19879_(), color));
        for (Player otherPlayer : player.m_9236_().m_6907_()) {
            if (otherPlayer.equals((Object)player)) continue;
            XyCore.Network.send(player, new CBColorSyncPacket(otherPlayer.m_19879_(), ColorCapability.colorOf(otherPlayer)));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        int colorOfOriginal = ColorCapability.colorOf(original);
        clone.getCapability(CoreCapabilities.Player.Color).ifPresent(colorCapability -> colorCapability.setColor(colorOfOriginal));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        XyCore.Network.broadcast(new CBColorSyncPacket(player.m_19879_(), ColorCapability.colorOf(player)));
        for (Player otherPlayer : player.m_9236_().m_6907_()) {
            if (otherPlayer.equals((Object)player)) continue;
            XyCore.Network.send(player, new CBColorSyncPacket(otherPlayer.m_19879_(), ColorCapability.colorOf(otherPlayer)));
        }
    }
}

