/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterTextureAtlasSpriteLoadersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.client.render.model.ConnectedTextureModel;
import tv.soaryn.xycraft.core.client.render.texture.FXAtlasSpriteLoader;
import tv.soaryn.xycraft.core.config.CoreConfig;
import tv.soaryn.xycraft.core.content.ContentRegistry;
import tv.soaryn.xycraft.core.content.CoreCapabilities;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.capabilities.level.AccurateTime;
import tv.soaryn.xycraft.core.utils.NotableColors;
import tv.soaryn.xycraft.core.utils.Utils;

public class XyCoreClient {

    @Mod.EventBusSubscriber(modid="xycraft_core", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeBus {
        @SubscribeEvent
        public static void onTagsUpdated(TagsUpdatedEvent event) {
            LocalPlayer player;
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD && (player = Minecraft.m_91087_().f_91074_) != null && ((Boolean)CoreConfig.ShowReloadMessage.get()).booleanValue()) {
                player.m_5496_(SoundEvents.f_11871_, 0.2f, 1.0f);
                player.m_213846_((Component)Component.m_237115_((String)"xycraft.core.system.finished_reloading"));
            }
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Level> event) {
            final LazyOptional accurateTime = LazyOptional.of(AccurateTime.Handle::new);
            event.addCapability(new ResourceLocation("xycraft_core", "time_capability"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return CoreCapabilities.Time.orEmpty(cap, accurateTime.cast());
                }
            });
        }

        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            if (((Boolean)CoreConfig.ShowItemTags.get()).booleanValue() && event.getFlags().m_7050_()) {
                Object[] array = event.getItemStack().m_204131_().toArray();
                if (array.length == 0) {
                    return;
                }
                event.getToolTip().add(Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237113_((String)"Item Tags").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE})));
                for (Object o : array) {
                    if (!(o instanceof TagKey)) continue;
                    TagKey itemTag = (TagKey)o;
                    event.getToolTip().add(Component.m_237113_((String)("   " + itemTag.f_203868_())).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="xycraft_core", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        public static Gson GsonInstance = new Gson();

        @SubscribeEvent
        public static void onRegisterSpriteLoader(RegisterTextureAtlasSpriteLoadersEvent event) {
            event.register("fxsprite", (ITextureAtlasSpriteLoader)new FXAtlasSpriteLoader());
        }

        @SubscribeEvent
        public static void setup(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, AccurateTime.Handle::onClientTick);
            Utils.CLIENT_LEVEL_SUPPLIER = () -> Minecraft.m_91087_().f_91073_;
            Utils.CLIENT_PLAYER_SUPPLIER = () -> Minecraft.m_91087_().f_91074_;
        }

        @SubscribeEvent
        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register("connected_textures", (IGeometryLoader)new ConnectedTextureModel.Loader());
        }

        @SubscribeEvent
        public static void onRegisterColorHandler(RegisterColorHandlersEvent.Block event) {
            event.register((state, level, pos, index) -> ((IColored)state.m_60734_()).getColorOfBlock(state, level, pos, index), ContentRegistry.getColorableBlocks());
        }

        @SubscribeEvent
        public static void onRegisterColorHandler(RegisterColorHandlersEvent.Item event) {
            event.register((stack, index) -> ((IColored)((BlockItem)stack.m_41720_()).m_40614_()).getColorOfItem(stack, index), (ItemLike[])ContentRegistry.getColorableItemBlocks());
            event.register((stack, index) -> ((IColored)stack.m_41720_()).getColorOfItem(stack, index), (ItemLike[])ContentRegistry.getColorableItems());
        }

        @SubscribeEvent
        public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((barrier, resourceManager, prepareProfiler, applyProfiler, prepareExecutor, applyExecutor) -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                Optional optional = resourceManager.m_213713_(new ResourceLocation("xycraft_core", "settings/colors.json"));
                return optional.map(resource -> {
                    ColorSettings colorSettings;
                    InputStreamReader reader = new InputStreamReader(resource.m_215507_());
                    try {
                        colorSettings = (ColorSettings)GsonInstance.fromJson((Reader)reader, ColorSettings.class);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            XyCore.Logger.error(e.toString());
                            XyCore.Logger.error("Aaaaah color settings is wrong!");
                            return new ColorSettings();
                        }
                    }
                    reader.close();
                    return colorSettings;
                }).orElseGet(ColorSettings::new);
            }, prepareExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenAcceptAsync(colorSettings -> {
                CustomColors.Blue.Color = Integer.decode(colorSettings.blue) | 0xFF000000;
                CustomColors.Green.Color = Integer.decode(colorSettings.green) | 0xFF000000;
                CustomColors.Red.Color = Integer.decode(colorSettings.red) | 0xFF000000;
                CustomColors.Dark.Color = Integer.decode(colorSettings.dark) | 0xFF000000;
                CustomColors.Light.Color = Integer.decode(colorSettings.light) | 0xFF000000;
                NotableColors.Creative.Color = Integer.decode(colorSettings.creative) | 0xFF000000;
            }, applyExecutor));
        }

        public static class ColorSettings {
            public String blue = "0x0064ff";
            public String green = "0x00ff00";
            public String red = "0xff0000";
            public String dark = "0x2e2e2e";
            public String light = "0xffffff";
            public String creative = "0xff8800";
        }
    }
}

