/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import com.teamabnormals.blueprint.core.api.conditions.loot.ConfigLootCondition;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.BlockSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="blueprint")
public final class DataUtil {
    public static final Field TAG_MANAGER = ObfuscationReflectionHelper.findField(ReloadableServerResources.class, (String)"f_206849_");
    public static final Field REGISTRY_ACCESS = ObfuscationReflectionHelper.findField(TagManager.class, (String)"f_144569_");
    private static final Method ADD_MIX_METHOD = ObfuscationReflectionHelper.findMethod(PotionBrewing.class, (String)"m_43513_", (Class[])new Class[]{Potion.class, Item.class, Potion.class});
    private static final Vector<AlternativeDispenseBehavior> ALTERNATIVE_DISPENSE_BEHAVIORS = new Vector();
    private static final Vector<CustomNoteBlockInstrument> CUSTOM_NOTE_BLOCK_INSTRUMENTS = new Vector();
    private static final ArrayList<Pair<ResourceLocation, Pair<Function<RegistryAccess, StructurePoolElement>, Integer>>> TEMPLATE_POOL_ADDITIONS = new ArrayList();

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().m_206579_();
        Registry structureTemplatePoolRegistry = registryAccess.m_175515_(Registries.f_256948_);
        TEMPLATE_POOL_ADDITIONS.forEach((Consumer<Pair<ResourceLocation, Pair<Function<RegistryAccess, StructurePoolElement>, Integer>>>)((Consumer<Pair>)addition -> {
            StructureTemplatePool structureTemplatePool = (StructureTemplatePool)structureTemplatePoolRegistry.m_7745_((ResourceLocation)addition.getFirst());
            if (structureTemplatePool != null) {
                Pair elementWithWeight = (Pair)addition.getSecond();
                int weight = (Integer)elementWithWeight.getSecond();
                ObjectArrayList jigsawPieces = structureTemplatePool.f_210560_;
                StructurePoolElement element = (StructurePoolElement)((Function)elementWithWeight.getFirst()).apply(registryAccess);
                for (int i = 0; i < weight; ++i) {
                    jigsawPieces.add(element);
                }
            }
        }));
    }

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, encouragement, flammability);
    }

    public static void registerCompostable(ItemLike item, float chance) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }

    public static void addMix(Potion input, Item reactant, Potion result) {
        try {
            ADD_MIX_METHOD.invoke(null, input, reactant, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to add mix for " + ForgeRegistries.POTIONS.getKey((Object)result) + " from " + ForgeRegistries.ITEMS.getKey((Object)reactant), e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockColor(BlockColors blockColors, BlockColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            blockColors.m_92589_(color, blocks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockItemColor(ItemColors itemColors, ItemColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            itemColors.m_92689_(color, (ItemLike[])blocks);
        }
    }

    public static void registerVillagerGift(VillagerProfession profession) {
        ResourceLocation name = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession);
        if (name != null) {
            GiveGiftToHero.f_147550_.put(profession, new ResourceLocation(name.m_135827_(), "gameplay/hero_of_the_village/" + name.m_135815_() + "_gift"));
        }
    }

    public static void registerParrotImitation(EntityType<?> entityType, SoundEvent soundEvent) {
        Parrot.f_29358_.put(entityType, soundEvent);
    }

    public static void addParrotFood(Item ... items) {
        Collections.addAll(Parrot.f_29357_, items);
    }

    @SafeVarargs
    public static void registerDecoratedPotPattern(Pair<Item, RegistryObject<String>> ... entries) {
        HashMap itemToPotTextureMap = Maps.newHashMap((Map)DecoratedPotPatterns.f_271367_);
        for (Pair<Item, RegistryObject<String>> entry : entries) {
            itemToPotTextureMap.put((Item)entry.getFirst(), ((RegistryObject)entry.getSecond()).getKey());
        }
        DecoratedPotPatterns.f_271367_ = itemToPotTextureMap;
    }

    public static <T> T[] concatArrays(T[] array, T ... toAdd) {
        int arrayLength = array.length;
        int toAddLength = toAdd.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), arrayLength + toAddLength);
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        System.arraycopy(toAdd, 0, newArray, arrayLength, toAddLength);
        return newArray;
    }

    public static <T> void concatArrays(Field arrayField, @Nullable Object object, T ... toAdd) {
        try {
            arrayField.set(object, DataUtil.concatArrays((Object[])arrayField.get(object), toAdd));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void changeBlockLocalization(Block block, String modid, String name) {
        block.f_49787_ = Util.m_137492_((String)"block", (ResourceLocation)new ResourceLocation(modid, name));
    }

    public static void changeBlockLocalization(String inputMod, String input, String outputMod, String output) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputMod, input));
        if (block != null) {
            block.f_49787_ = Util.m_137492_((String)"block", (ResourceLocation)new ResourceLocation(outputMod, output));
        }
    }

    public static void changeItemLocalization(Item item, String modid, String name) {
        item.f_41379_ = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation(modid, name));
    }

    public static void changeItemLocalization(String inputMod, String input, String outputMod, String output) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputMod, input));
        if (item != null) {
            item.f_41379_ = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation(outputMod, output));
        }
    }

    public static boolean matchesKeys(ResourceLocation loc, ResourceKey<?> ... keys) {
        for (ResourceKey<?> key : keys) {
            if (!key.m_135782_().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static void registerAlternativeDispenseBehavior(AlternativeDispenseBehavior behavior) {
        ALTERNATIVE_DISPENSE_BEHAVIORS.add(behavior);
    }

    public static void registerNoteBlockInstrument(CustomNoteBlockInstrument instrument) {
        CUSTOM_NOTE_BLOCK_INSTRUMENTS.add(instrument);
    }

    public static synchronized void addToJigsawPattern(ResourceLocation toAdd, Function<RegistryAccess, StructurePoolElement> newPieceFactory, int weight) {
        TEMPLATE_POOL_ADDITIONS.add((Pair<ResourceLocation, Pair<Function<RegistryAccess, StructurePoolElement>, Integer>>)Pair.of((Object)toAdd, (Object)Pair.of(newPieceFactory, (Object)weight)));
    }

    public static LootItemConditionType registerConfigCondition(String modId, Object ... configObjects) {
        HashMap configValues = new HashMap();
        for (Object object : configObjects) {
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getAnnotation(ConfigKey.class) == null || !ForgeConfigSpec.ConfigValue.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    configValues.put(field.getAnnotation(ConfigKey.class).value(), (ForgeConfigSpec.ConfigValue)field.get(object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        CraftingHelper.register((IConditionSerializer)new ConfigValueCondition.Serializer(modId, configValues));
        return new LootItemConditionType((Serializer)new ConfigLootCondition.ConfigSerializer(modId, configValues));
    }

    public static void registerConfigPredicate(IConfigPredicateSerializer<?> serializer) {
        ResourceLocation key = serializer.getID();
        if (ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate config predicate serializer: " + key);
        }
        ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.put(key, serializer);
    }

    public static List<AlternativeDispenseBehavior> getSortedAlternativeDispenseBehaviors() {
        ArrayList<AlternativeDispenseBehavior> behaviors = new ArrayList<AlternativeDispenseBehavior>(ALTERNATIVE_DISPENSE_BEHAVIORS);
        Collections.sort(behaviors);
        return behaviors;
    }

    public static List<CustomNoteBlockInstrument> getSortedCustomNoteBlockInstruments() {
        ArrayList<CustomNoteBlockInstrument> instruments = new ArrayList<CustomNoteBlockInstrument>(CUSTOM_NOTE_BLOCK_INSTRUMENTS);
        Collections.sort(instruments);
        return instruments;
    }

    public static RegistryOps<JsonElement> createRegistryOps(ReloadableServerResources serverResources) throws IllegalAccessException {
        return RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)((RegistryAccess)REGISTRY_ACCESS.get(TAG_MANAGER.get(serverResources))));
    }

    public static <T, R> Function<T, R> memoize(final Function<T, R> function) {
        return new Function<T, R>(){
            private volatile boolean initialized;
            private R value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t) {
                if (!this.initialized) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.initialized) {
                            this.initialized = true;
                            this.value = function.apply(t);
                            return this.value;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static class CustomNoteBlockInstrument
    implements Comparable<CustomNoteBlockInstrument> {
        protected final String modId;
        protected final Comparator<String> modIdComparator;
        protected final Predicate<BlockSource> condition;
        private final SoundEvent sound;
        private final boolean isMobHead;

        public CustomNoteBlockInstrument(String modId, Predicate<BlockSource> condition, SoundEvent sound, boolean isMobHead) {
            this(modId, condition, sound, isMobHead, (id1, id2) -> 0);
        }

        public CustomNoteBlockInstrument(String modId, Predicate<BlockSource> condition, SoundEvent sound) {
            this(modId, condition, sound, false, (id1, id2) -> 0);
        }

        public CustomNoteBlockInstrument(String modId, Predicate<BlockSource> condition, SoundEvent sound, boolean isMobHead, Comparator<String> modIdComparator) {
            this.modId = modId;
            this.condition = condition;
            this.sound = sound;
            this.isMobHead = isMobHead;
            this.modIdComparator = modIdComparator;
        }

        @Override
        public int compareTo(CustomNoteBlockInstrument instrument) {
            return this.modIdComparator.compare(this.modId, instrument.modId);
        }

        public boolean test(BlockSource source) {
            return this.condition.test(source);
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public boolean isMobHead() {
            return this.isMobHead;
        }
    }

    public static class AlternativeDispenseBehavior
    implements Comparable<AlternativeDispenseBehavior> {
        protected final String modId;
        protected final Item item;
        protected final BiPredicate<BlockSource, ItemStack> condition;
        protected final DispenseItemBehavior behavior;
        protected final Comparator<String> modIdComparator;

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior) {
            this(modId, item, condition, behavior, (id1, id2) -> 0);
        }

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior, Comparator<String> modIdComparator) {
            this.modId = modId;
            this.item = item;
            this.condition = condition;
            this.behavior = behavior;
            this.modIdComparator = modIdComparator;
        }

        @Override
        public int compareTo(AlternativeDispenseBehavior behavior) {
            return this.item == behavior.item ? this.modIdComparator.compare(this.modId, behavior.modId) : 0;
        }

        public void register() {
            DispenseItemBehavior oldBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(this.item);
            DispenserBlock.m_52672_((ItemLike)this.item, (source, stack) -> this.condition.test(source, stack) ? this.behavior.m_6115_(source, stack) : oldBehavior.m_6115_(source, stack));
        }
    }

    public record ReadMappedList<E>(List<E> list, Function<E, E> mapper) implements List<E>
    {
        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objects = this.list.toArray();
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = this.mapper.apply(objects[i]);
            }
            return objects;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] objects = this.list.toArray(a);
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = this.mapper.apply(objects[i]);
            }
            return objects;
        }

        @Override
        public boolean add(E t) {
            return this.list.add(t);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public E get(int index) {
            return this.mapper.apply(this.list.get(index));
        }

        @Override
        public E set(int index, E element) {
            return this.list.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            this.list.add(index, element);
        }

        @Override
        public E remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListItr(this.list.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ListItr(this.list.listIterator(index));
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ReadMappedList<E>(this.subList(fromIndex, toIndex), this.mapper);
        }

        public class ListItr
        implements ListIterator<E> {
            private final ListIterator<E> listIterator;

            public ListItr(ListIterator<E> listIterator) {
                this.listIterator = listIterator;
            }

            @Override
            public boolean hasNext() {
                return this.listIterator.hasNext();
            }

            @Override
            public E next() {
                return ReadMappedList.this.mapper.apply(this.listIterator.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.listIterator.hasPrevious();
            }

            @Override
            public E previous() {
                return ReadMappedList.this.mapper.apply(this.listIterator.previous());
            }

            @Override
            public int nextIndex() {
                return this.listIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.listIterator.previousIndex();
            }

            @Override
            public void remove() {
                this.listIterator.remove();
            }

            @Override
            public void set(E e) {
                this.listIterator.set(e);
            }

            @Override
            public void add(E e) {
                this.listIterator.add(e);
            }
        }
    }
}

