/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.common.remolder.Remolder;
import com.teamabnormals.blueprint.common.remolder.RemolderEntry;
import com.teamabnormals.blueprint.common.remolder.RemolderTypes;
import com.teamabnormals.blueprint.common.remolder.data.MoldingTypes;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RemolderProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    private final PackOutput.Target packOutputTarget;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final ArrayList<Entry> entries = new ArrayList();

    public RemolderProvider(String modId, PackOutput.Target packOutputTarget, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.modId = modId;
        this.packOutputTarget = packOutputTarget;
        this.pathProvider = packOutput.m_245269_(packOutputTarget, "remolders");
        this.lookupProvider = lookupProvider;
    }

    protected abstract void registerEntries(HolderLookup.Provider var1);

    protected Entry entry(ResourceLocation name) {
        Entry entry = new Entry(name);
        this.entries.add(entry);
        return entry;
    }

    protected Entry entry(String name) {
        return this.entry(new ResourceLocation(this.modId, name));
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return this.lookupProvider.thenCompose(provider -> {
            ArrayList<Entry> entries = this.entries;
            entries.clear();
            this.registerEntries((HolderLookup.Provider)provider);
            PackOutput.PathProvider pathProvider = this.pathProvider;
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
            return CompletableFuture.allOf((CompletableFuture[])entries.stream().map(entry -> {
                Path resolvedPath = pathProvider.m_245731_(entry.name);
                try {
                    DataResult dataResult = RemolderEntry.CODEC.encodeStart((DynamicOps)registryOps, (Object)new RemolderEntry(entry.pathSelector, entry.packs, entry.molding, entry.remolder));
                    Optional error = dataResult.error();
                    if (error.isPresent()) {
                        throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
                    }
                    return DataProvider.m_253162_((CachedOutput)output, (JsonElement)((JsonElement)dataResult.result().get()), (Path)resolvedPath);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Couldn't save remolder {}", (Object)resolvedPath, (Object)e);
                    return CompletableFuture.completedFuture(null);
                }
            }).toArray(CompletableFuture[]::new));
        });
    }

    public String m_6055_() {
        return "Remolders (" + this.packOutputTarget + "): " + this.modId;
    }

    public static final class Entry {
        private final ResourceLocation name;
        private ConditionedResourceSelector pathSelector = ConditionedResourceSelector.EMPTY;
        @Nullable
        private Set<String> packs = null;
        private MoldingTypes.MoldingType<?> molding = MoldingTypes.JSON;
        private Remolder remolder = RemolderTypes.noop();

        public Entry(ResourceLocation name) {
            this.name = name;
        }

        public Entry path(ConditionedResourceSelector selector) {
            this.pathSelector = selector;
            return this;
        }

        public Entry path(ResourceSelector<?> selector) {
            return this.path(new ConditionedResourceSelector(selector));
        }

        public Entry path(String ... names) {
            return this.path(new NamesResourceSelector(names));
        }

        public Entry pack(Set<String> packs) {
            this.packs = packs;
            return this;
        }

        public Entry molding(MoldingTypes.MoldingType<?> molding) {
            this.molding = molding;
            return this;
        }

        public Entry remolder(Remolder remolder) {
            this.remolder = remolder;
            return this;
        }
    }
}

