/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.village;

import com.mojang.datafixers.util.Pair;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TemplatePoolsAdditions {
    private static final List<StructureTemplatePoolInjector> ADDITIONS = new ArrayList<StructureTemplatePoolInjector>();
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public static void injectStructureTemplatePool() {
        new StructureTemplatePoolInjector().addPool(new ResourceLocation("minecraft:village/desert/town_centers")).addAddition("stargate/village/milkyway/{stargate_size}/desert/basic_1", 500).addAddition("stargate/village/milkyway/{stargate_size}/desert/basic_2", 500).addAddition("stargate/village/milkyway/{stargate_size}/desert/big_1", 500).add().addPool(new ResourceLocation("minecraft:village/plains/town_centers")).addAddition("stargate/village/milkyway/{stargate_size}/plains/aschen", 500).add().addPool(new ResourceLocation("minecraft:village/savanna/town_centers")).addAddition("stargate/village/milkyway/{stargate_size}/savanna/aschen", 500).add().addPool(new ResourceLocation("minecraft:village/snowy/town_centers")).addAddition("stargate/village/milkyway/{stargate_size}/snowy/aschen", 500).add().addPool(new ResourceLocation("minecraft:village/taiga/town_centers")).addAddition("stargate/village/milkyway/{stargate_size}/snowy/aschen", 500).add();
    }

    public static void runVillageAdditionsAdder() {
        Registry templatePoolRegistry = (Registry)JSG.currentServer.m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)JSG.currentServer.m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        for (StructureTemplatePoolInjector addition : ADDITIONS) {
            for (ResourceLocation villagePool : addition.poolsIds) {
                StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(villagePool);
                if (pool == null) continue;
                ArrayList<Pair> raw = new ArrayList<Pair>();
                for (Map.Entry<String, Pair<Integer, Boolean>> structure : addition.additions.entrySet()) {
                    Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
                    ResourceLocation structurePath = new ResourceLocation("jsg", structure.getKey().replaceAll("\\{stargate_size}", ((StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get())).structuresPath));
                    SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)structurePath.toString(), (Holder)emptyProcessorList).apply((Boolean)structure.getValue().getSecond() != false ? StructureTemplatePool.Projection.TERRAIN_MATCHING : StructureTemplatePool.Projection.RIGID);
                    for (int i = 0; i < (Integer)structure.getValue().getFirst(); ++i) {
                        pool.f_210560_.add((Object)piece);
                    }
                    raw.add(new Pair((Object)piece, (Object)((Integer)structure.getValue().getFirst())));
                }
                pool.f_210559_ = raw;
            }
        }
    }

    public static class StructureTemplatePoolInjector {
        public final List<ResourceLocation> poolsIds = new ArrayList<ResourceLocation>();
        public final Map<String, Pair<Integer, Boolean>> additions = new HashMap<String, Pair<Integer, Boolean>>();

        public StructureTemplatePoolInjector addPool(ResourceLocation loc) {
            this.poolsIds.add(loc);
            return this;
        }

        public StructureTemplatePoolInjector addAddition(String loc, int weight) {
            return this.addAddition(loc, weight, false);
        }

        public StructureTemplatePoolInjector addAddition(String loc, int weight, boolean matchTerrain) {
            this.additions.put(loc, (Pair<Integer, Boolean>)Pair.of((Object)weight, (Object)matchTerrain));
            return this;
        }

        public StructureTemplatePoolInjector add() {
            ADDITIONS.add(this);
            return new StructureTemplatePoolInjector();
        }
    }
}

