/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.worldgen.dimension;

import dev.tauri.jsg.api.StargateGenerator;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.helpers.DimensionsHelper;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargateReservedAddresses;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.worldgen.CustomDimensionsEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SpecialStructuresHandler {
    public static Map<ResourceLocation, SpecialStructuresHandler> HANDLERS_STORAGE = new HashMap<ResourceLocation, SpecialStructuresHandler>();
    public final List<SpecialStructure> storage = new ArrayList<SpecialStructure>();

    public static void register() {
        HANDLERS_STORAGE.put(CustomDimensionsEnum.ABYDOS.location, new SpecialStructuresHandler().addStructure(new SpecialStructure(new ResourceLocation("jsg", "abydos_pyramid"), -140, 23).setBaseFiller(Blocks.f_50471_.m_49966_(), 60).setContainsReservedStargate(StargateReservedAddresses.ABYDOS_STARGATE).addPart("jsg:/abydos/pyramid/core", new BlockPos(0, 0, 0), true, true).addPart("jsg:/abydos/pyramid/back", new BlockPos(47, 0, 0)).addPart("jsg:/abydos/pyramid/front", new BlockPos(-47, 0, 0)).addPart("jsg:/abydos/pyramid/foyer", new BlockPos(-94, 0, 0)).addPart("jsg:/abydos/pyramid/ramp", new BlockPos(-141, 0, 0)).addPart("jsg:/abydos/pyramid/back_left", new BlockPos(47, 0, -47)).addPart("jsg:/abydos/pyramid/back_right", new BlockPos(47, 0, 47)).addPart("jsg:/abydos/pyramid/front_right", new BlockPos(-47, 0, 47)).addPart("jsg:/abydos/pyramid/front_left", new BlockPos(-47, 0, -47)).addPart("jsg:/abydos/pyramid/left", new BlockPos(0, 0, -47)).addPart("jsg:/abydos/pyramid/right", new BlockPos(0, 0, 47)).addPart("jsg:/abydos/pyramid/peak", new BlockPos(0, 47, 0), false, false)));
    }

    public static void tryGenerateStructures(MinecraftServer server) {
        for (Map.Entry<ResourceLocation, SpecialStructuresHandler> handlerEntry : HANDLERS_STORAGE.entrySet()) {
            if (handlerEntry.getValue() == null) {
                return;
            }
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)handlerEntry.getKey());
            ServerLevel level = server.m_129880_(dim);
            for (SpecialStructure structure : handlerEntry.getValue().storage) {
                structure.dimension = level;
                structure.tryGenerate(false);
            }
        }
    }

    public SpecialStructuresHandler addStructure(SpecialStructure structureData) {
        this.storage.add(structureData);
        return this;
    }

    public static class SpecialStructure {
        public ServerLevel dimension;
        public final int[] position;
        public final ResourceLocation id;
        public BlockState baseFiller = Blocks.f_50016_.m_49966_();
        public StargateReservedAddresses.ReservedStargate reservedStargate = null;
        public int baseHeight = 0;
        public boolean getOnlyOnePartRandom = false;
        public final Map<String, BlockPos> structureParts = new HashMap<String, BlockPos>();
        public final Map<String, Boolean> structurePartsFillBase = new HashMap<String, Boolean>();
        public final Map<String, Boolean> structurePartsIsStargate = new HashMap<String, Boolean>();

        public SpecialStructure(ResourceLocation id, int ... position) {
            this.id = id;
            this.position = position;
        }

        public SpecialStructure setBaseFiller(BlockState baseFiller, int baseHeight) {
            this.baseFiller = baseFiller;
            this.baseHeight = baseHeight;
            return this;
        }

        public SpecialStructure setContainsReservedStargate(StargateReservedAddresses.ReservedStargate stargate) {
            this.reservedStargate = stargate;
            return this;
        }

        public SpecialStructure setGetOnlyOnePartRandom() {
            this.getOnlyOnePartRandom = true;
            return this;
        }

        public SpecialStructure addPart(String path, BlockPos position) {
            return this.addPart(path, position, true, false);
        }

        public SpecialStructure addPart(String path, BlockPos position, boolean fillBase, boolean isStargateStructure) {
            this.structureParts.put(path, position);
            this.structurePartsFillBase.put(path, fillBase);
            this.structurePartsIsStargate.put(path, isStargateStructure);
            return this;
        }

        public void tryGenerate(boolean regenerate) {
            if (this.dimension == null) {
                return;
            }
            StargateNetwork sgNetwork = StargateNetwork.INSTANCE;
            if (sgNetwork.generatedSpecialStructures.contains(this.id) && !regenerate) {
                return;
            }
            StructureTemplateManager manager = this.dimension.m_215082_();
            StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false);
            Set<Map.Entry<String, BlockPos>> parts = this.structureParts.entrySet();
            if (this.getOnlyOnePartRandom) {
                RandomSource rand = this.dimension.f_46441_;
                boolean init = true;
                for (Map.Entry<String, BlockPos> e : this.structureParts.entrySet()) {
                    if (init) {
                        parts = Collections.singleton(e);
                        init = false;
                    }
                    if (!rand.m_188499_()) continue;
                    parts = Collections.singleton(e);
                    break;
                }
            }
            BlockPos bestPos = DimensionsHelper.getTopBlockWithPos(this.dimension, this.position[0], this.position[1], 16, 16);
            this.dimension.m_8904_().m_27056_((LevelReader)this.dimension, bestPos, 128);
            for (Map.Entry<String, BlockPos> entry : parts) {
                StructureTemplate structure = manager.m_230359_(new ResourceLocation(entry.getKey().replaceAll("\\{stargateSize}", ((StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get())).structuresPath)));
                BlockPos placePos = entry.getValue().m_121955_((Vec3i)bestPos);
                structure.m_230328_((ServerLevelAccessor)this.dimension, placePos, placePos, placeSettings, this.dimension.f_46441_, 18);
                BoundingBox structureBox = structure.m_74633_(placeSettings, placePos);
                if (this.structurePartsIsStargate.get(entry.getKey()).booleanValue()) {
                    JSGAxisAlignedBB aabb = new JSGAxisAlignedBB(structureBox);
                    Iterable poses = BlockPos.m_121940_((BlockPos)aabb.getMinBlockPos(), (BlockPos)aabb.getMaxBlockPos());
                    StargateClassicBaseBE foundBase = null;
                    DHDAbstractBE foundDHD = null;
                    for (BlockPos pos : poses) {
                        DHDAbstractBE dhdTile;
                        if (foundDHD != null && foundBase != null) break;
                        BlockEntity tile = this.dimension.m_7702_(pos = pos.m_7949_());
                        if (tile instanceof StargateClassicBaseBE) {
                            StargateClassicBaseBE baseTile;
                            foundBase = baseTile = (StargateClassicBaseBE)tile;
                        }
                        if (!(tile instanceof DHDAbstractBE)) continue;
                        foundDHD = dhdTile = (DHDAbstractBE)tile;
                    }
                    if (foundBase != null) {
                        StargateGenerator.PlacementConfig config = new StargateGenerator.PlacementConfig();
                        Integer stargateCapacity = (Integer)JSGConfig.Stargate.stargateEnergyStorage.get();
                        config.setStargateEnergyInternalSmart((int)(Math.max(this.dimension.f_46441_.m_188500_(), 0.1) * (double)stargateCapacity.intValue()));
                        config.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_MW);
                        config.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE);
                        if (foundDHD != null) {
                            config.dhdPos = foundDHD.m_58899_();
                            config.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_DHD);
                            config.dhdFluid = (Integer)JSGConfig.DialHomeDevice.fluidCapacity.get();
                        }
                        config.baseInPlace = true;
                        foundBase.regenerateStargate(config);
                        if (this.reservedStargate != null) {
                            this.reservedStargate.setAddresses(foundBase);
                        }
                    }
                }
                if (!this.structurePartsFillBase.get(entry.getKey()).booleanValue()) continue;
                int minX = structureBox.m_162395_();
                int maxX = structureBox.m_162399_();
                int minZ = structureBox.m_162398_();
                int maxZ = structureBox.m_162401_();
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockPos posCheck = new BlockPos(x, placePos.m_123342_(), z);
                        if (this.dimension.m_8055_(posCheck).m_60795_()) continue;
                        for (int y = 0; y > -this.baseHeight; --y) {
                            int actualY = y + (placePos.m_123342_() - 1);
                            BlockPos pos = new BlockPos(x, actualY, z);
                            this.dimension.m_7731_(pos, this.baseFiller, 18);
                        }
                    }
                }
            }
            sgNetwork.generatedSpecialStructures.add(this.id);
            sgNetwork.m_77762_();
        }
    }
}

