/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.util;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class JSGAdvancementsUtil {
    public static void tryTriggerRangedAdvancement(BlockEntity tile, EnumAdvancementType advancementType) {
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = tile.m_58899_();
        int radius = 25;
        List players = world.m_45971_(ServerPlayer.class, TargetingConditions.m_148353_(), null, (AABB)new JSGAxisAlignedBB(pos.m_7918_(-radius, -radius, -radius), pos.m_7918_(radius, radius, radius)));
        for (ServerPlayer player : players) {
            switch (advancementType) {
                case GATE_OPEN: {
                    if (!(tile instanceof StargateClassicBaseBE)) break;
                    int dialedSize = ((StargateClassicBaseBE)tile).getDialedAddress().size();
                    JSGAdvancements.CHEVRON_SEVEN_LOCKED.trigger(player);
                    if (dialedSize >= 8) {
                        JSGAdvancements.CHEVRON_EIGHT_LOCKED.trigger(player);
                    }
                    if (dialedSize < 9) break;
                    JSGAdvancements.CHEVRON_NINE_LOCKED.trigger(player);
                    break;
                }
                case GATE_MERGE: {
                    if (!(tile instanceof StargateAbstractBaseBE) || !(tile instanceof StargateMilkyWayBaseBE)) break;
                    JSGAdvancements.MERGED_MILKYWAY.trigger(player);
                    break;
                }
                case IRIS_IMPACT: {
                    JSGAdvancements.IRIS_IMPACT.trigger(player);
                    break;
                }
                case ZPM_HUB: {
                    JSGAdvancements.THREE_ZPMS.trigger(player);
                    break;
                }
                case ZPM_SLOT: {
                    JSGAdvancements.ZPM_SLOT.trigger(player);
                    break;
                }
            }
        }
    }

    public static enum EnumAdvancementType {
        GATE_OPEN,
        GATE_MERGE,
        GATE_FLICKER,
        IRIS_IMPACT,
        ZPM_HUB,
        ZPM_SLOT;

    }
}

