/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.state;

import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.state.State;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class StateSoundPositionedUpdate
extends State {
    public Map<Integer, Boolean> soundMap = new HashMap<Integer, Boolean>();

    public StateSoundPositionedUpdate() {
        this.soundMap = new HashMap<Integer, Boolean>();
    }

    public StateSoundPositionedUpdate(@Nullable SoundPositionedEnum sound, boolean play) {
        if (sound == null) {
            return;
        }
        this.soundMap.put(sound.ordinal(), play);
    }

    public void add(@Nullable SoundPositionedEnum sound, boolean play) {
        if (sound == null) {
            return;
        }
        this.soundMap.put(sound.ordinal(), play);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.soundMap.size());
        for (Map.Entry<Integer, Boolean> e : this.soundMap.entrySet()) {
            buf.writeInt(e.getKey().intValue());
            buf.writeBoolean(e.getValue().booleanValue());
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.soundMap = new HashMap<Integer, Boolean>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            boolean play = buf.readBoolean();
            this.soundMap.put(id, play);
        }
    }
}

