/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUsage;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SymbolTypeEnum<T extends SymbolInterface> {
    public static SymbolTypeEnum<?> byId(int id) {
        return SymbolTypeRegistry.REGISTRY.get(id);
    }

    public static SymbolTypeEnum<?> byId(String id) {
        return SymbolTypeRegistry.REGISTRY_STRING.get(id);
    }

    public static int getId(SymbolTypeEnum<?> type) {
        return SymbolTypeRegistry.REGISTRY_REVERSED.get(type);
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SymbolTypeEnum)) {
            return false;
        }
        SymbolTypeEnum s = (SymbolTypeEnum)o;
        return Objects.equals(s.getId(), this.getId());
    }

    @Nonnull
    public static SymbolTypeEnum<?> getRandom() {
        return SymbolTypeEnum.byId((int)(Math.random() * (double)SymbolTypeRegistry.currentId));
    }

    public static SymbolTypeEnum<?>[] values(@Nullable SymbolUsage usage) {
        if (usage == null) {
            return SymbolTypeRegistry.REGISTRY.values().toArray(new SymbolTypeEnum[0]);
        }
        Map<Integer, SymbolTypeEnum<?>> map = SymbolTypeRegistry.REGISTRY_USAGE.get(usage);
        if (map == null) {
            return new SymbolTypeEnum[0];
        }
        return map.values().toArray(new SymbolTypeEnum[0]);
    }

    public boolean hasOrigin() {
        return this.getOrigin() != null;
    }

    public abstract int[] getAncientTitlePos();

    @OnlyIn(value=Dist.CLIENT)
    public abstract Tab.TabBuilder finalizeAddressTab(Tab.TabBuilder var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract TabAddress.SymbolCoords getSymbolCoords(int var1);

    public abstract T[] getValues();

    public abstract Block getBaseBlock();

    public abstract Item getGlyphUpgrade();

    public abstract Block getDHDBlock();

    public abstract String getId();

    public abstract T getBRB();

    public abstract int getIconWidth();

    public abstract int getIconHeight();

    public abstract T getRandomSymbol(Random var1);

    public abstract T getOrigin();

    public abstract int getMaxSymbolsDisplay(boolean var1);

    public abstract int getMinimalSymbolCountTo(SymbolTypeEnum<?> var1, boolean var2);

    public abstract boolean validateDialedAddress(StargateAddressDynamic var1);

    public abstract float getAnglePerGlyph();

    public float getAngleByAngIndex(int index) {
        return index;
    }

    public float getAngleOfNearest(float angle) {
        return 0.0f;
    }

    public abstract T getSymbolByAngle(float var1);

    public abstract T getTopSymbol();

    public abstract T valueOf(int var1);

    public abstract T fromEnglishName(String var1);

    public abstract T getFirstValidForAddress();
}

