/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolMilkyWayEnum;
import dev.tauri.jsg.stargate.network.SymbolPegasusEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUniverseEnum;
import dev.tauri.jsg.worldgen.CustomDimensionsEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class StargateReservedAddresses {
    private static final Map<ResourceLocation, Map<SymbolTypeEnum<?>, StargateAddress>> REGISTRY = new HashMap();
    public static ReservedStargate ABYDOS_STARGATE = StargateReservedAddresses.registerStargate(CustomDimensionsEnum.ABYDOS.location, new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.TAURUS, SymbolMilkyWayEnum.SERPENSCAPUT, SymbolMilkyWayEnum.CAPRICORNUS, SymbolMilkyWayEnum.MONOCEROS, SymbolMilkyWayEnum.SAGITTARIUS, SymbolMilkyWayEnum.ORION, SymbolMilkyWayEnum.CANISMINOR, SymbolMilkyWayEnum.AURIGA).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.ACJESIS, SymbolPegasusEnum.BASELAI, SymbolPegasusEnum.DANAMI, SymbolPegasusEnum.ECRUMIG, SymbolPegasusEnum.AAXEL, SymbolPegasusEnum.GILLTIN, SymbolPegasusEnum.HACEMILL, SymbolPegasusEnum.RECKTIC).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G5, SymbolUniverseEnum.G6, SymbolUniverseEnum.G18, SymbolUniverseEnum.G20, SymbolUniverseEnum.G1, SymbolUniverseEnum.G7, SymbolUniverseEnum.G22, SymbolUniverseEnum.G31).build());
    public static ReservedStargate NETHER = StargateReservedAddresses.registerStargate(Level.f_46429_.m_135782_(), new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.AURIGA, SymbolMilkyWayEnum.LEOMINOR, SymbolMilkyWayEnum.LYNX, SymbolMilkyWayEnum.SCORPIUS, SymbolMilkyWayEnum.CAPRICORNUS, SymbolMilkyWayEnum.VIRGO, SymbolMilkyWayEnum.CANISMINOR, SymbolMilkyWayEnum.SERPENSCAPUT).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.BASELAI, SymbolPegasusEnum.ACJESIS, SymbolPegasusEnum.DANAMI, SymbolPegasusEnum.ECRUMIG, SymbolPegasusEnum.AAXEL, SymbolPegasusEnum.GILLTIN, SymbolPegasusEnum.HACEMILL, SymbolPegasusEnum.RECKTIC).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G6, SymbolUniverseEnum.G5, SymbolUniverseEnum.G18, SymbolUniverseEnum.G20, SymbolUniverseEnum.G1, SymbolUniverseEnum.G7, SymbolUniverseEnum.G22, SymbolUniverseEnum.G31).build());

    public static ReservedStargate registerStargate(ResourceLocation dimension, Map<SymbolTypeEnum<?>, StargateAddress> addresses) {
        REGISTRY.put(dimension, addresses);
        return new ReservedStargate(dimension, addresses);
    }

    public static Map<SymbolTypeEnum<?>, StargateAddress> getStargate(@Nonnull ResourceLocation dim) {
        return REGISTRY.get(dim);
    }

    public static void register() {
    }

    public record ReservedStargate(ResourceLocation dimension, Map<SymbolTypeEnum<?>, StargateAddress> addresses) {
        public void setAddresses(StargateAbstractBaseBE baseTile) {
            for (Map.Entry<SymbolTypeEnum<?>, StargateAddress> addressEntry : this.addresses.entrySet()) {
                baseTile.setGateAddress(addressEntry.getKey(), addressEntry.getValue());
            }
        }
    }

    public static class AddressesBuilder {
        Map<SymbolTypeEnum<?>, StargateAddress> addressMap = new HashMap();

        public AddressesBuilder setAddress(SymbolTypeEnum<?> type, SymbolInterface ... symbols) {
            if (symbols.length < 8) {
                return this;
            }
            StargateAddress address = new StargateAddress(type);
            address.address.clear();
            address.address.addAll(List.of(symbols));
            this.addressMap.put(type, address);
            return this;
        }

        public Map<SymbolTypeEnum<?>, StargateAddress> build() {
            return this.addressMap;
        }
    }
}

