/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.stargate.network.IAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class StargateAddress
implements IAddress {
    protected SymbolTypeEnum<?> symbolType;
    protected List<SymbolInterface> address = new ArrayList<SymbolInterface>(8);

    public StargateAddress(SymbolTypeEnum<?> symbolType) {
        this.symbolType = symbolType;
    }

    public StargateAddress(ByteBuf byteBuf) {
        this.fromBytes(byteBuf);
    }

    public StargateAddress(CompoundTag compound) {
        this.deserializeNBT(compound);
    }

    protected int getSavedSymbols() {
        return 8;
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return this.symbolType;
    }

    public StargateAddress generate(Random random) {
        if (!this.address.isEmpty()) {
            JSG.logger.error("Tried to regenerate address already containing symbols", (Throwable)new ConcurrentModificationException());
            for (SymbolInterface s : this.address) {
                JSG.logger.error(s.getEnglishName());
            }
            return this;
        }
        while (this.address.size() < 8) {
            Object symbol = this.symbolType.getRandomSymbol(random);
            if (this.address.contains(symbol)) continue;
            this.address.add((SymbolInterface)symbol);
        }
        return this;
    }

    @Override
    public SymbolInterface get(int pos) {
        return this.address.get(pos);
    }

    public void set(int index, SymbolInterface symbol) {
        this.address.set(index, symbol);
    }

    public SymbolInterface getLast() {
        if (this.address.isEmpty()) {
            return null;
        }
        return this.address.get(this.address.size() - 1);
    }

    @Override
    public int getSize() {
        return this.address.size();
    }

    public List<String> getNameList() {
        ArrayList<String> out = new ArrayList<String>(this.address.size());
        for (SymbolInterface symbol : this.address) {
            out.add(symbol.getEnglishName());
        }
        return out;
    }

    public List<SymbolInterface> subList(int start, int end) {
        return this.address.subList(start, end);
    }

    public List<SymbolInterface> getAdditional() {
        return this.address.subList(6, 8);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("symbolType", SymbolTypeEnum.getId(this.symbolType));
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            compound.m_128405_("symbol" + i, this.address.get(i).getId());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        if (!this.address.isEmpty()) {
            JSG.logger.error("Tried to deserialize address already containing symbols", (Throwable)new ConcurrentModificationException());
            for (SymbolInterface s : this.address) {
                JSG.logger.error(s.getEnglishName());
            }
            return;
        }
        this.symbolType = SymbolTypeEnum.byId(compound.m_128451_("symbolType"));
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            this.address.add((SymbolInterface)this.symbolType.valueOf(compound.m_128451_("symbol" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(SymbolTypeEnum.getId(this.symbolType));
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            buf.writeByte(this.address.get(i).getId());
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (!this.address.isEmpty()) {
            JSG.logger.error("Tried to deserialize address already containing symbols");
            return;
        }
        this.symbolType = SymbolTypeEnum.byId(buf.readByte());
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            this.address.add((SymbolInterface)this.symbolType.valueOf(buf.readByte()));
        }
    }

    public String toString() {
        StringBuilder stringAddress = new StringBuilder();
        for (SymbolInterface symbol : this.address) {
            stringAddress.append(symbol.getEnglishName()).append(", ");
        }
        return "{symbolType: " + String.valueOf(this.symbolType) + ", address: [" + stringAddress.toString() + "]}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.subList(0, 6).hashCode());
        result = 31 * result + (this.symbolType == null ? 0 : this.symbolType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StargateAddress)) {
            return false;
        }
        StargateAddress other = (StargateAddress)obj;
        if (this.address == null) {
            return other.address == null;
        }
        if (this.address.size() < 6) {
            return false;
        }
        if (other.address.size() < 6) {
            return false;
        }
        if (!this.address.subList(0, 6).equals(other.address.subList(0, 6))) {
            return false;
        }
        List<SymbolInterface> noPoO = this.trimOrigin();
        List<SymbolInterface> otherNoPoO = other.trimOrigin();
        if (noPoO.size() >= 7 && otherNoPoO.size() >= 7) {
            if (!noPoO.get(6).equals(otherNoPoO.get(6))) {
                return false;
            }
            if (noPoO.size() >= 8 && otherNoPoO.size() >= 8 && !noPoO.get(7).equals(otherNoPoO.get(7))) {
                return false;
            }
        }
        return this.symbolType == other.symbolType;
    }

    public List<SymbolInterface> trimOrigin() {
        if (this.address == null) {
            return null;
        }
        if (this.address.isEmpty()) {
            return this.address;
        }
        if (this.address.get(this.address.size() - 1).origin()) {
            return this.address.subList(0, this.address.size() - 1);
        }
        return this.address;
    }

    public boolean equalsV2(StargateAddressDynamic address) {
        return this.equalsV2(address, address.getSize());
    }

    public boolean equalsV2(StargateAddressDynamic address, int checkLength) {
        for (int i = 0; i < address.getSize() && i + 1 <= checkLength; ++i) {
            if (this.address.size() >= i + 1) {
                if (this.address.get(i) == address.get(i)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean contains(SymbolInterface symbol) {
        for (SymbolInterface s : this.address) {
            if (!s.equals(symbol)) continue;
            return true;
        }
        return false;
    }
}

