/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionAndRotationToClient;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.util.math.MathHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlackHoleAnimationState
extends State {
    public static final int TIME_BEFORE_DEPTH_CHANGE = 100;
    public static final int MAX_GRAVITY_FIELD_RADIUS = 25;
    public static final int BACK_VORTEX_FORMING_ANIMATION_TIME = 3600;
    public StargateAbstractBaseBE gate;
    public boolean isConnectedToBlackHole = false;
    public boolean isIncoming = false;
    public long isConnectedToBlackHoleFrom = -1L;

    public BlackHoleAnimationState(@Nonnull StargateAbstractBaseBE gate) {
        this.gate = gate;
    }

    public void setConnectedToBlackHole(boolean connected, boolean isIncoming) {
        if (connected && !this.isConnectedToBlackHole) {
            this.isConnectedToBlackHoleFrom = this.gate.openedSince;
        }
        this.isConnectedToBlackHole = connected;
        this.isIncoming = isIncoming;
        this.gate.m_6596_();
        this.sendUpdateToClient();
    }

    public void sendUpdateToClient() {
        this.gate.getAndSendState(StateTypeEnum.BLACK_HOLE_ANIMATION_UPDATE);
    }

    public void tick() {
        if (!this.isConnectedToBlackHole) {
            return;
        }
        if (this.gate.m_58904_() == null || this.gate.m_58904_().f_46443_) {
            return;
        }
        if (this.gate.getStargateState().notInitiating() || this.gate.getStargateState().idle()) {
            this.setConnectedToBlackHole(false, false);
            return;
        }
        if (this.getGravitationalFieldStrength() > 0.0f) {
            BlockPos gateCenter = this.gate.getGateCenterPos();
            Level level = this.gate.m_58904_();
            if (level == null) {
                return;
            }
            Direction fieldDirection = this.gate.getFacingVertical() != Direction.SOUTH ? this.gate.getFacingVertical() : this.gate.getFacing();
            int currentRadius = (int)(25.0f * (this.getGravitationalFieldStrength() / 2.0f));
            if (currentRadius <= 0) {
                return;
            }
            BlockPos fieldCenter = gateCenter.m_121955_(fieldDirection.m_122436_().m_142393_(currentRadius)).m_121955_(fieldDirection.m_122436_());
            BlockPos gateCenterOffsetOne = gateCenter.m_121955_(fieldDirection.m_122424_().m_122436_());
            JSGAxisAlignedBB box = new JSGAxisAlignedBB(fieldCenter, currentRadius);
            List entities = level.m_45933_(null, (AABB)box);
            for (Entity entity : entities) {
                Vec3 ePos = entity.m_20182_();
                double distanceToGateCenter = Math.sqrt(gateCenter.m_203193_((Position)ePos));
                double motionFactor = ((double)(currentRadius * 2) - distanceToGateCenter) / (double)(currentRadius * 10);
                if (motionFactor <= 0.0) continue;
                Vec3 vectorToGate = new Vec3((double)gateCenterOffsetOne.m_123341_() - ePos.m_7096_(), (double)gateCenterOffsetOne.m_123342_() - ePos.m_7098_(), (double)gateCenterOffsetOne.m_123343_() - ePos.m_7094_()).m_82541_();
                vectorToGate = vectorToGate.m_82542_(motionFactor, motionFactor, motionFactor);
                Vec3 newMotion = entity.m_20184_().m_82549_(vectorToGate);
                if (this.isIncoming) {
                    newMotion = newMotion.m_82548_();
                }
                entity.m_20256_(newMotion);
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)entity;
                JSGPacketHandler.sendTo(new StargateMotionAndRotationToClient(newMotion, entity.m_146909_(), entity.m_146908_(), false, true), sp);
            }
        }
    }

    public float getBackVortexDepth() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        float f = (float)(this.gate.getTime() - this.isConnectedToBlackHoleFrom - 100L) / 3600.0f;
        return (float)(this.isIncoming ? -1 : 1) * MathHelper.clamp(f, 0.0f, 1.0f);
    }

    public float getBackVortexAngle() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        float f = (float)(this.gate.getTime() - this.isConnectedToBlackHoleFrom) / 3600.0f;
        return MathHelper.clamp(f, 0.0f, 2.0f) * (float)(this.gate.getTime() - this.isConnectedToBlackHoleFrom);
    }

    public float getBackVortexRed() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        return (float)(this.isIncoming ? -1 : 1) * this.getBackVortexDepth();
    }

    public float getGravitationalFieldStrength() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        return this.getBackVortexDepth();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isConnectedToBlackHole);
        buf.writeLong(this.isConnectedToBlackHoleFrom);
        buf.writeBoolean(this.isIncoming);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.isConnectedToBlackHole = buf.readBoolean();
        this.isConnectedToBlackHoleFrom = buf.readLong();
        this.isIncoming = buf.readBoolean();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("isConnectedToBlackHole", this.isConnectedToBlackHole);
        compound.m_128356_("isConnectedToBlackHoleFrom", this.isConnectedToBlackHoleFrom);
        compound.m_128379_("isIncoming", this.isIncoming);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.isConnectedToBlackHole = compound.m_128471_("isConnectedToBlackHole");
        this.isConnectedToBlackHoleFrom = compound.m_128454_("isConnectedToBlackHoleFrom");
        this.isIncoming = compound.m_128471_("isIncoming");
    }
}

