/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.stargate.network.StargatePos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;

public class AutoCloseManager
implements INBTSerializable<CompoundTag> {
    private StargateAbstractBaseBE gateTile;
    private int secondsPassed;
    private int playersPassed;

    public AutoCloseManager(StargateAbstractBaseBE gateTile) {
        this.gateTile = gateTile;
    }

    public void reset() {
        this.secondsPassed = 0;
        this.playersPassed = 0;
    }

    public void playerPassing() {
        ++this.playersPassed;
    }

    public boolean shouldClose(StargatePos sourceStargatePos) {
        if (this.gateTile.getTime() % 20L == 0L) {
            Level sourceWorld = sourceStargatePos.getWorld();
            BlockPos sourcePos = sourceStargatePos.gatePos;
            boolean sourceLoaded = sourceWorld.m_46749_(sourcePos);
            if (this.playersPassed > 0) {
                AABB scanBox;
                int playerCount;
                this.secondsPassed = sourceLoaded ? ((playerCount = sourceWorld.m_6249_((Entity)null, scanBox = new AABB(sourcePos.m_121955_(new Vec3i(-10, -5, -10)), sourcePos.m_121955_(new Vec3i(10, 5, 10))), e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        return !p.m_21224_();
                    }
                    return false;
                }).size()) == 0 ? ++this.secondsPassed : 0) : ++this.secondsPassed;
            }
            return this.secondsPassed >= (Integer)JSGConfig.Stargate.secondsToAutoclose.get() + 3;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("secondsPassed", this.secondsPassed);
        compound.m_128405_("playersPassed", this.playersPassed);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        if (compound == null) {
            return;
        }
        this.secondsPassed = compound.m_128451_("secondsPassed");
        this.playersPassed = compound.m_128451_("playersPassed");
    }
}

