/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.sound;

import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.sound.FlybySoundInstance;
import dev.tauri.jsg.sound.JSGPositionedSound;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JSGSoundHelperClient {
    private static final Map<BlockPos, Map<SoundPositionedEnum, JSGPositionedSound>> POSITIONED_SOUND_RECORDS_MAP = new HashMap<BlockPos, Map<SoundPositionedEnum, JSGPositionedSound>>();

    public static JSGPositionedSound getRecord(SoundPositionedEnum soundEnum, BlockPos pos) {
        Map soundRecordsMapPos = POSITIONED_SOUND_RECORDS_MAP.computeIfAbsent(pos, k -> new HashMap());
        JSGPositionedSound soundRecord = (JSGPositionedSound)((Object)soundRecordsMapPos.get((Object)soundEnum));
        if (soundRecord == null) {
            soundRecord = soundEnum.getInstance(pos);
            soundRecordsMapPos.put(soundEnum, soundRecord);
            POSITIONED_SOUND_RECORDS_MAP.put(pos, soundRecordsMapPos);
        }
        return soundRecord;
    }

    public static void playPositionedSoundClientSide(BlockPos pos, SoundPositionedEnum soundEnum, boolean play) {
        if (pos == null) {
            return;
        }
        JSGPositionedSound soundRecord = JSGSoundHelperClient.getRecord(soundEnum, pos);
        if (play) {
            soundRecord.play();
        } else {
            soundRecord.stopPlaying();
        }
    }

    public static void playSoundEventClientSide(BlockPos pos, SoundEventEnum sound, float volumeModifier, float pitchModifier) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)sound.event.get(), SoundSource.AMBIENT, (float)((double)sound.volume * (Double)JSGConfig.General.volume.get()) * volumeModifier, pitchModifier, RandomSource.m_216327_(), pos));
    }

    public static FlybySoundInstance playPositionedFlyBySound(BlockPos pos, SoundPositionedEnum sound, float volumeModifier, float pitchModifier) {
        FlybySoundInstance ins = new FlybySoundInstance((SoundEvent)sound.event.get(), SoundSource.AMBIENT, sound.volume * volumeModifier, pitchModifier, RandomSource.m_216327_(), pos);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)ins);
        return ins;
    }
}

