/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolUsage;
import dev.tauri.jsg.state.State;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class StargateContainerGuiState
extends State {
    public Map<SymbolTypeEnum<?>, StargateAddress> gateAdddressMap;
    public JSGTileEntityConfig config;

    public StargateContainerGuiState() {
    }

    public StargateContainerGuiState(Map<SymbolTypeEnum<?>, StargateAddress> gateAdddressMap, JSGTileEntityConfig config) {
        this.gateAdddressMap = gateAdddressMap;
        this.config = config;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        for (SymbolTypeEnum<?> symbolType : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            this.gateAdddressMap.get(symbolType).toBytes(buf);
        }
        this.config.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.gateAdddressMap = new HashMap(3);
        for (SymbolTypeEnum<?> symbolType : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            StargateAddress address = new StargateAddress(symbolType);
            address.fromBytes(buf);
            this.gateAdddressMap.put(symbolType, address);
        }
        this.config = new JSGTileEntityConfig(buf);
    }
}

