/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TabAddress
extends Tab {
    private final StargateClassicBaseBE gateTile;
    private final SymbolTypeEnum<?> symbolType;
    private final int progressColor;
    private int maxSymbols;

    protected TabAddress(TabAddressBuilder builder) {
        super(builder);
        this.gateTile = builder.gateTile;
        this.symbolType = builder.symbolType;
        this.progressColor = builder.progressColor;
        this.maxSymbols = 6;
    }

    public static TabAddressBuilder builder() {
        return new TabAddressBuilder();
    }

    public void setMaxSymbols(int maxSymbols) {
        this.maxSymbols = maxSymbols;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        super.render(graphics, mouseX, mouseY);
        if (this.isVisible() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            Texture.bindTextureWithMc(this.bgTexLocation);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX + 105, this.guiTop + this.defaultY + 86, 6.0f, 179.0f, 18, 18, this.textureSize, this.textureSize);
            int shadow = 2;
            float color = 1.0f;
            if (this.symbolType == SymbolTypeRegistry.UNIVERSE) {
                color = 0.0f;
            }
            int originId = this.gateTile.getOriginId(StargateTypeEnum.parse(this.symbolType));
            for (int i = 0; i < this.maxSymbols; ++i) {
                SymbolInterface symbol = Objects.requireNonNull(this.gateTile.getStargateAddress(this.symbolType)).get(i);
                if (symbol.renderIconByMinecraft(originId)) {
                    Texture.bindTextureWithMc(symbol.getIconResource(originId));
                } else {
                    TextureLoader.INSTANCE.getTexture(symbol.getIconResource(originId)).bindTexture();
                }
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                GuiHelper.drawTexturedRectWithShadow(symbolCoords.x, symbolCoords.y, shadow, shadow, this.symbolType.getIconWidth(), this.symbolType.getIconHeight(), color);
            }
            RenderSystem.enableBlend();
            Texture.bindTextureWithMc(this.bgTexLocation);
            short progress = this.gateTile.getPageProgress();
            Color c = new Color(this.progressColor);
            float red = c.getRed();
            float green = c.getGreen();
            float blue = c.getBlue();
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX + 97, this.guiTop + this.defaultY + 86 + (18 - progress), 0.0f, 179 + (18 - progress), 6, progress, this.textureSize, this.textureSize);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderFg(graphics, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            for (int i = 0; i < this.maxSymbols; ++i) {
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                if (!GuiHelper.isPointInRegion(symbolCoords.x, symbolCoords.y, this.symbolType.getIconWidth(), this.symbolType.getIconHeight(), mouseX, mouseY)) continue;
                graphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237113_((String)Objects.requireNonNull(this.gateTile.getStargateAddress(this.symbolType)).get(i).localize())), Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    public Tab.SlotTab createSlot(SlotHandler slot) {
        return new Tab.SlotTab(slot, slotTab -> {
            int x = this.currentOffsetX + 106;
            int y = this.defaultY + 87;
            return slotTab.setXY(x, y);
        });
    }

    public SymbolCoords getSymbolCoords(int symbol) {
        SymbolCoords got = this.symbolType.getSymbolCoords(symbol);
        return new SymbolCoords(got.x + this.guiLeft + this.currentOffsetX, got.y + this.guiTop + this.defaultY);
    }

    public static class TabAddressBuilder
    extends Tab.TabBuilder {
        private StargateClassicBaseBE gateTile;
        private SymbolTypeEnum<?> symbolType;
        private int progressColor;

        public TabAddressBuilder setGateTile(StargateClassicBaseBE gateTile) {
            this.gateTile = gateTile;
            return this;
        }

        public TabAddressBuilder setSymbolType(SymbolTypeEnum<?> symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public TabAddressBuilder setProgressColor(int color) {
            this.progressColor = color;
            return this;
        }

        @Override
        public TabAddress build() {
            return new TabAddress(this);
        }
    }

    public record SymbolCoords(int x, int y) {
    }
}

