/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.base;

import dev.tauri.jsg.screen.util.GuiHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class JSGGuiBase
extends Screen {
    public static final int FRAME_COLOR = -16777216;
    public static final int BG_COLOR = -232314061;
    public static final int TEXT_COLOR = 7042700;
    public boolean isOpen = false;
    protected int imageWidth;
    protected int imageHeight;
    protected int frameThickness;
    protected int frameColor;
    protected int bgColor;
    protected int textColor;
    protected int padding;
    protected int id;
    public GuiGraphics graphics;
    public int mouseX;
    public int mouseY;
    public float partialTick;

    public void m_7856_() {
        this.isOpen = true;
    }

    public void m_7379_() {
        this.isOpen = false;
    }

    public JSGGuiBase(int w, int h, int frameThickness, int frameColor, int bgColor, int textColor, int padding) {
        super((Component)Component.m_237113_((String)""));
        this.imageWidth = w;
        this.imageHeight = h;
        this.frameThickness = frameThickness;
        this.frameColor = frameColor;
        this.bgColor = bgColor;
        this.textColor = textColor;
        this.padding = padding;
        this.id = 0;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    protected int getTopLeftInside() {
        return this.frameThickness + this.padding;
    }

    protected int getBottomRightInside(boolean returnHeight) {
        return returnHeight ? this.imageHeight - this.getTopLeftInside() : this.imageWidth - this.getTopLeftInside();
    }

    protected int getTopLeftAbsolute(boolean returnHeight) {
        return (int)(returnHeight ? (float)(this.f_96544_ - this.imageHeight) / 2.0f : (float)(this.f_96543_ - this.imageWidth) / 2.0f);
    }

    protected void translateToCenter() {
        this.graphics.m_280168_().m_252880_((float)(this.f_96543_ - this.imageWidth) / 2.0f, (float)(this.f_96544_ - this.imageHeight) / 2.0f, 0.0f);
    }

    protected void drawBackground() {
        this.frame(0, 0, this.imageWidth, this.imageHeight, this.frameThickness, this.frameColor, true);
    }

    protected void setBackGroundSize(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
    }

    protected void frame(int x, int y, int w, int h, int thickness, int color, boolean background) {
        GuiHelper.drawRect(x, y, x + w, y + thickness, color);
        GuiHelper.drawRect(x, y + h - thickness, x + w, y + h, color);
        GuiHelper.drawRect(x, y + thickness, x + thickness, y + h - thickness, color);
        GuiHelper.drawRect(x + w - thickness, y + thickness, x + w, y + h - thickness, color);
        if (background) {
            GuiHelper.drawRect(x + thickness, y + thickness, x + w - thickness, y + h - thickness, this.bgColor);
        }
    }

    protected int drawString(String text, int x, int y, int color) {
        this.graphics.m_280056_(this.f_96547_, text, x += this.getTopLeftInside(), y += this.getTopLeftInside() - 1, color, true);
        return this.f_96547_.m_92895_(text);
    }

    protected void drawVerticallCenteredString(String text, int x, int y, int color) {
        int len = this.f_96547_.m_92895_(text);
        this.drawString(text, x += (this.imageWidth - this.getTopLeftInside() - len) / 2, y, color);
    }

    protected void drawTextBox(EditBox tf) {
        int x = tf.m_252754_() - 2;
        int y = tf.m_252907_() - 2;
        int x2 = tf.m_252754_() + tf.m_5711_();
        int y2 = tf.m_252907_() + tf.m_93694_();
        GuiHelper.drawRect(x - 1, y - 1, x2 + 1, y2 + 1, this.frameColor);
        GuiHelper.drawRect(x, y, x2, y2, -14868442);
        tf.m_88315_(this.graphics, this.mouseX, this.mouseY, this.partialTick);
    }

    protected EditBox createTextField(int x, int y, int maxLength, String defaultText) {
        return this.createTextField(x, y, this.getBottomRightInside(false) - (x + this.getTopLeftInside()) - 6, maxLength, defaultText);
    }

    protected EditBox createTextField(int x, int y, int width, int maxLength, String defaultText) {
        int x1 = x + this.getTopLeftInside();
        int y1 = y + this.getTopLeftInside();
        EditBox tf = new EditBox(this.f_96547_, x1 + 3, y1 - 1, width + 2, 9, (Component)Component.m_237113_((String)""));
        tf.m_94199_(maxLength);
        tf.m_94182_(false);
        tf.m_94144_(defaultText);
        return tf;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.graphics = guiGraphics;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTick = partialTicks;
    }
}

