/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRenderer;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.renderer.stargate.StargateRendererStatic;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumIrisType;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public abstract class StargateClassicRenderer<S extends StargateClassicRendererState>
extends StargateAbstractRenderer<S> {
    protected static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("jsg", "textures/tesr/iris/shield.jpg");
    public static final int PHYSICAL_IRIS_ANIMATION_LENGTH = 60;
    public static final int SHIELD_IRIS_ANIMATION_LENGTH = 10;

    public StargateClassicRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    public abstract float getGateDiameter();

    public abstract double getScaleMultiplier();

    @Override
    protected void applyTransformations() {
        float scale = (float)(((StargateClassicRendererState)this.rendererState).stargateSize.renderScale * this.getScaleMultiplier());
        this.stack.m_85837_(0.5, (double)(this.getGateDiameter() * scale / 2.0f) + 0.2, 0.5);
        this.stack.m_85841_(scale, scale, scale);
    }

    protected abstract void renderChevron(ChevronEnum var1, boolean var2);

    @Override
    public void renderWholeGate() {
        this.setGateHeatColor();
        super.renderWholeGate();
    }

    protected void renderChevrons() {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.stack.m_85836_();
            this.renderChevron(chevron, false);
            int chevronLight = (int)((float)((StargateClassicRendererState)this.rendererState).chevronTextureList.CHEVRON_STATE_MAP.get(chevron).intValue() * 1.5f);
            float maxLight = Math.max(this.combinedLight, LightTexture.m_109885_((int)chevronLight, (int)chevronLight));
            if (chevronLight > 2) {
                OBJModel.setDynamicLightning(maxLight / 1.572888E7f);
            }
            this.renderChevron(chevron, true);
            OBJModel.resetDynamicLightning();
            this.stack.m_85849_();
        }
        ((StargateClassicRendererState)this.rendererState).chevronTextureList.iterate(this.level, this.partialTicks);
    }

    @Override
    public void renderIris(boolean backOnly) {
        float irisAnimationStage = this.level.m_46467_() - ((StargateClassicRendererState)this.rendererState).irisAnimation;
        EnumIrisState irisState = ((StargateClassicRendererState)this.rendererState).irisState;
        EnumIrisType irisType = ((StargateClassicRendererState)this.rendererState).irisType;
        if (irisType == null || irisState == null) {
            return;
        }
        if (irisState == EnumIrisState.OPENED) {
            return;
        }
        if (irisType == EnumIrisType.SHIELD) {
            int k;
            if ((irisAnimationStage *= 0.07f) > 0.7f) {
                irisAnimationStage = 0.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 0.7f - irisAnimationStage;
            }
            this.stack.m_85836_();
            Texture irisTexture = TextureLoader.INSTANCE.getTexture(SHIELD_TEXTURE);
            if (irisTexture != null) {
                irisTexture.bindTexture();
            }
            float tick = (float)this.level.m_46467_() + this.partialTicks;
            RenderSystem.enableBlend();
            this.stack.m_85837_(0.0, 0.0, 0.13);
            this.stack.m_85836_();
            StargateRendererStatic.currentStack = this.stack;
            int n = k = backOnly ? 1 : 0;
            while (k < 2) {
                if (k == 1) {
                    this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                }
                StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1, this.getShieldColor());
                for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                    strip.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1, this.getShieldColor());
                }
                ++k;
            }
            RenderSystem.disableBlend();
            this.stack.m_85849_();
            this.stack.m_85849_();
        }
        if ((irisType == EnumIrisType.IRIS_TITANIUM || irisType == EnumIrisType.IRIS_TRINIUM || irisType == EnumIrisType.IRIS_CREATIVE) && backOnly) {
            this.setIrisHeatColor();
            irisAnimationStage *= 0.028333334f;
            if (irisAnimationStage > 1.7f) {
                irisAnimationStage = 1.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 1.7f - irisAnimationStage;
            }
            for (float i = 0.0f; i < 20.0f; i += 1.0f) {
                float rotateIndex = 18.0f * i;
                this.stack.m_85836_();
                this.stack.m_252781_(Axis.f_252403_.m_252977_(rotateIndex));
                this.stack.m_252880_(-irisAnimationStage, -(irisAnimationStage * 2.0f), this.getIrisBladeTilt());
                ElementEnum.IRIS.bindTextureAndRender(this.stack);
                this.stack.m_85849_();
            }
        }
    }

    public float getIrisBladeTilt() {
        return 0.02f;
    }

    public void setIrisHeatColor(float red) {
        OBJModel.setRGB(1.0f + red * 3.0f, 1.0f, 1.0f, 1.0f);
    }

    public float[] getShieldColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public void setIrisHeatColor() {
        if (((StargateClassicRendererState)this.rendererState).irisHeat == -1.0) {
            this.setIrisHeatColor(0.0f);
            return;
        }
        float red = (float)(((StargateClassicRendererState)this.rendererState).irisHeat / (((StargateClassicRendererState)this.rendererState).irisType == EnumIrisType.IRIS_TITANIUM ? StargateClassicBaseBE.IRIS_MAX_HEAT_TITANIUM : StargateClassicBaseBE.IRIS_MAX_HEAT_TRINIUM));
        if (((StargateClassicRendererState)this.rendererState).irisType == EnumIrisType.IRIS_CREATIVE) {
            red = 0.0f;
        }
        this.setIrisHeatColor(red);
    }

    public void setGateHeatColor() {
        if (((StargateClassicRendererState)this.rendererState).gateHeat == -1.0) {
            return;
        }
        float red = (float)(((StargateClassicRendererState)this.rendererState).gateHeat / StargateClassicBaseBE.GATE_MAX_HEAT);
        OBJModel.setRGB(1.0f + red * 2.7f, 1.0f, 1.0f, 1.0f);
    }
}

