/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import dev.tauri.jsg.renderer.stargate.StargateAbstractRenderer;
import dev.tauri.jsg.renderer.stargate.StargateRendererStatic;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.state.State;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;

public class StargateAbstractRendererState
extends State {
    public BlockPos pos;
    private BiomeOverlayEnum biomeOverlay;
    public boolean doEventHorizonRender = false;
    public StargateAbstractRenderer.EnumVortexState vortexState = StargateAbstractRenderer.EnumVortexState.FORMING;
    public StargateRendererStatic.QuadStrip backStrip;
    public StargateRendererStatic.QuadStrip frontStrip;
    public boolean backStripClamp;
    public boolean frontStripClamp;
    public Float whiteOverlayAlpha;
    public long gateWaitStart = 0L;
    public long gateWaitClose = 0L;
    public boolean zeroAlphaSet;
    public boolean horizonUnstable = false;
    public int horizonSegments = 0;
    public boolean noxDialing = false;
    public float backVortexDepth = 0.0f;

    public StargateAbstractRendererState() {
    }

    protected StargateAbstractRendererState(StargateAbstractRendererStateBuilder builder) {
        if (builder.stargateState.engaged() || builder.stargateState == EnumStargateState.UNSTABLE_OPENING) {
            this.doEventHorizonRender = true;
            this.vortexState = StargateAbstractRenderer.EnumVortexState.STILL;
        }
    }

    public StargateAbstractRendererState initClient(BlockPos pos, BiomeOverlayEnum biomeOverlay) {
        this.pos = pos;
        this.biomeOverlay = biomeOverlay;
        return this;
    }

    public void openGate(long totalWorldTime, boolean noxDialing) {
        this.gateWaitStart = totalWorldTime;
        this.zeroAlphaSet = false;
        this.backStripClamp = true;
        this.frontStripClamp = true;
        this.whiteOverlayAlpha = Float.valueOf(1.0f);
        this.vortexState = StargateAbstractRenderer.EnumVortexState.FORMING;
        this.doEventHorizonRender = true;
        this.noxDialing = noxDialing;
    }

    public void updateBackVortex(float backVortexDepth) {
        this.backVortexDepth = backVortexDepth;
    }

    public void closeGate(long totalWorldTime) {
        this.gateWaitClose = totalWorldTime;
        this.vortexState = StargateAbstractRenderer.EnumVortexState.CLOSING;
    }

    public BiomeOverlayEnum getBiomeOverlay() {
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.doEventHorizonRender);
        buf.writeInt(this.vortexState.index);
        buf.writeFloat(this.backVortexDepth);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.doEventHorizonRender = buf.readBoolean();
        this.vortexState = StargateAbstractRenderer.EnumVortexState.valueOf(buf.readInt());
        this.backVortexDepth = buf.readFloat();
    }

    public static StargateAbstractRendererStateBuilder builder() {
        return new StargateAbstractRendererStateBuilder();
    }

    public static class StargateAbstractRendererStateBuilder {
        protected EnumStargateState stargateState;

        public StargateAbstractRendererStateBuilder setStargateState(EnumStargateState stargateState) {
            this.stargateState = stargateState;
            return this;
        }

        public StargateAbstractRendererState build() {
            return new StargateAbstractRendererState(this);
        }
    }
}

