/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.raycaster.util;

import dev.tauri.jsg.util.vectors.Matrix3f;
import dev.tauri.jsg.util.vectors.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class RaycasterVertex {
    public final float x;
    public final float y;
    public final float z;
    private double xRotated;
    private double yRotated;
    private double zRotated;
    private double xGlobal;
    private double yGlobal;
    private double zGlobal;
    BlockPos oldGlobal = null;

    public RaycasterVertex(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return String.format("%f %f %f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public RaycasterVertex rotate(double angle) {
        angle = Math.toRadians(angle);
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cos(angle);
        Matrix3f rotationMatrix = new Matrix3f();
        Matrix3f vertex = new Matrix3f();
        Matrix3f out = new Matrix3f();
        rotationMatrix.m00 = cos;
        rotationMatrix.m10 = -sin;
        rotationMatrix.m20 = 0.0f;
        rotationMatrix.m01 = sin;
        rotationMatrix.m11 = cos;
        rotationMatrix.m21 = 0.0f;
        rotationMatrix.m02 = 0.0f;
        rotationMatrix.m12 = 0.0f;
        rotationMatrix.m22 = 1.0f;
        vertex.m00 = this.x;
        vertex.m01 = this.y;
        vertex.m02 = this.z;
        Matrix3f.mul(rotationMatrix, vertex, out);
        this.xRotated = out.m00;
        this.yRotated = out.m01;
        this.zRotated = out.m02;
        return this;
    }

    public RaycasterVertex localToGlobal(BlockPos pos, Vector3f translation) {
        if (!pos.equals((Object)this.oldGlobal)) {
            this.xGlobal = this.xRotated + (double)pos.m_123341_() + (double)translation.x;
            this.yGlobal = this.zRotated + (double)pos.m_123342_() + (double)translation.y;
            this.zGlobal = (double)pos.m_123343_() - this.yRotated + (double)translation.z;
            this.oldGlobal = pos;
        }
        return this;
    }

    public Vec3 getVec3() {
        return new Vec3(this.xGlobal, this.yGlobal, this.zGlobal);
    }
}

