/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.power.zpm;

import dev.tauri.jsg.power.zpm.IEnergyStorageZPM;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ZPMItemEnergyStorage
implements IEnergyStorageZPM {
    private final ItemStack stack;
    protected final long maxEnergyStored;

    public ZPMItemEnergyStorage(ItemStack stack, long maxEnergyStored) {
        this.stack = stack;
        this.maxEnergyStored = maxEnergyStored;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        if ((long)maxExtract > this.getEnergyStored()) {
            maxExtract = (int)this.getEnergyStored();
        }
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - (long)maxExtract);
        }
        return maxExtract;
    }

    public void setEnergyStored(long energy) {
        this.getOrCreateCompound(this.stack).m_128356_("longEnergy", energy);
    }

    @Override
    public long getEnergyStored() {
        CompoundTag tag = this.getOrCreateCompound(this.stack);
        if (tag.m_128441_("energy")) {
            return tag.m_128451_("energy");
        }
        return tag.m_128454_("longEnergy");
    }

    @Override
    public long getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    private CompoundTag getOrCreateCompound(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }
}

