/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.stargate.teleportation.TeleportHelper;
import dev.tauri.jsg.util.vectors.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class StargateMotionToServer
extends PositionedPacket {
    private int entityId;
    private float motionX;
    private float motionY;
    private float motionZ;

    public StargateMotionToServer() {
    }

    public StargateMotionToServer(int entityId, BlockPos pos, float motionX, float motionY, float motionZ) {
        super(pos);
        this.entityId = entityId;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public StargateMotionToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            Vector3f motionVector;
            Direction sourceFacing = (Direction)world.m_8055_(this.pos).m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
            Direction sourceFacingVertical = JSGProperties.getDirectionByVerticalFacing((Integer)world.m_8055_(this.pos).m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
            StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(this.pos);
            if (gateTile == null) {
                return;
            }
            if (TeleportHelper.frontSide(sourceFacingVertical == null || sourceFacingVertical == Direction.SOUTH ? sourceFacing : sourceFacingVertical, motionVector = new Vector3f(this.motionX, this.motionY, this.motionZ))) {
                gateTile.setMotionOfPassingEntity(this.entityId, motionVector);
                gateTile.teleportEntity(this.entityId);
            } else {
                gateTile.removeEntity(this.entityId);
            }
        });
    }
}

