/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.state.StateTypeEnum;
import java.nio.charset.StandardCharsets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SaveIrisCodeToServer
extends PositionedPacket {
    String code;
    EnumIrisMode mode;

    public SaveIrisCodeToServer() {
    }

    public SaveIrisCodeToServer(BlockPos pos, String code, EnumIrisMode mode) {
        super(pos);
        this.code = code;
        this.mode = mode;
    }

    public SaveIrisCodeToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.code.length());
        buf.writeCharSequence((CharSequence)this.code, StandardCharsets.UTF_8);
        buf.writeByte((int)this.mode.id);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        int codeSize = buf.readInt();
        this.code = buf.readCharSequence(codeSize, StandardCharsets.UTF_8).toString();
        this.mode = EnumIrisMode.getValue(buf.readByte());
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            BlockEntity patt1991$temp = world.m_7702_(this.pos);
            if (patt1991$temp instanceof StargateClassicBaseBE) {
                StargateClassicBaseBE te = (StargateClassicBaseBE)patt1991$temp;
                te.setIrisCode(this.code);
                te.setIrisMode(this.mode);
                JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_STATE, te.getState(StateTypeEnum.GUI_STATE)), player);
            }
        });
    }
}

