/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.entry;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.packet.JSGPacket;
import dev.tauri.jsg.packet.packets.entry.EntryActionEnum;
import dev.tauri.jsg.packet.packets.entry.EntryDataTypeEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.network.IAddress;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.teleportation.TeleportHelper;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EntryActionToServer
extends JSGPacket {
    private InteractionHand hand;
    private EntryDataTypeEnum dataType;
    private EntryActionEnum action;
    private int index;
    private String name;
    private int maxSymbols;
    private StargateAddressDynamic addressToDial;
    private BlockPos linkedGate;
    private StargatePos targetGatePos;
    private EnumDialingType dialType;
    private Map<SymbolTypeEnum<?>, StargateAddress> addresses = new HashMap();

    public EntryActionToServer() {
    }

    public EntryActionToServer(InteractionHand hand, StargateAddressDynamic addressToDial, StargatePos targetPos, BlockPos linkedGate, EnumDialingType dialType) {
        this.hand = hand;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = EntryActionEnum.DIAL;
        this.index = -1;
        this.name = "";
        this.addressToDial = addressToDial;
        this.maxSymbols = -1;
        this.targetGatePos = targetPos;
        this.linkedGate = linkedGate;
        this.dialType = dialType;
    }

    public EntryActionToServer(InteractionHand hand, String name, StargatePos targetGate) {
        this.hand = hand;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = EntryActionEnum.RENAME;
        this.index = -1;
        this.name = name;
        this.targetGatePos = targetGate;
        this.addressToDial = null;
        this.linkedGate = null;
    }

    public EntryActionToServer(EntryActionEnum action, StargatePos targetGate, Map<SymbolTypeEnum<?>, StargateAddress> addresses, boolean notGenerated) {
        this.hand = InteractionHand.MAIN_HAND;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = action;
        this.index = notGenerated ? 1 : 0;
        this.name = "";
        this.targetGatePos = targetGate;
        this.addressToDial = null;
        this.linkedGate = null;
        this.addresses = addresses;
    }

    public EntryActionToServer(EntryActionEnum action, BlockPos linkedGate) {
        this.hand = InteractionHand.MAIN_HAND;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = action;
        this.index = -1;
        this.name = "";
        this.linkedGate = linkedGate;
    }

    public EntryActionToServer(InteractionHand hand, EntryDataTypeEnum dataType, EntryActionEnum action, int index, String name) {
        this.hand = hand;
        this.dataType = dataType;
        this.action = action;
        this.index = index;
        this.name = name;
        this.addressToDial = null;
        this.targetGatePos = null;
        this.linkedGate = null;
    }

    public EntryActionToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    private static void tagSwitchPlaces(ListTag list, int a, int b) {
        Tag tagA = list.get(a);
        list.set(a, list.get(b));
        list.set(b, tagA);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.hand.ordinal());
        buf.writeInt(this.dataType.ordinal());
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.index);
        buf.m_130070_(this.name);
        buf.writeInt(this.maxSymbols);
        if (this.addressToDial != null) {
            buf.writeBoolean(true);
            this.addressToDial.toBytes((ByteBuf)buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.linkedGate != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.linkedGate.m_121878_());
        } else {
            buf.writeBoolean(false);
        }
        if (this.targetGatePos != null) {
            buf.writeBoolean(true);
            this.targetGatePos.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.dialType == null) {
            this.dialType = EnumDialingType.NORMAL;
        }
        buf.writeInt(this.dialType.ordinal());
        if (this.addresses != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.addresses.size());
            for (Map.Entry<SymbolTypeEnum<?>, StargateAddress> e : this.addresses.entrySet()) {
                buf.writeInt(SymbolTypeEnum.getId(e.getKey()));
                e.getValue().toBytes((ByteBuf)buf);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.hand = InteractionHand.values()[buf.readInt()];
        this.dataType = EntryDataTypeEnum.values()[buf.readInt()];
        this.action = EntryActionEnum.values()[buf.readInt()];
        this.index = buf.readInt();
        this.name = buf.m_130277_();
        this.maxSymbols = buf.readInt();
        if (buf.readBoolean()) {
            this.addressToDial = new StargateAddressDynamic((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.linkedGate = BlockPos.m_122022_((long)buf.readLong());
        }
        if (buf.readBoolean()) {
            this.targetGatePos = new StargatePos((ByteBuf)buf);
        }
        int i = buf.readInt();
        if (EnumDialingType.values().length <= i) {
            i = 0;
        }
        this.dialType = EnumDialingType.values()[i];
        if (buf.readBoolean()) {
            this.addresses = new HashMap();
            int ii = buf.readInt();
            for (int j = 0; j < ii; ++j) {
                SymbolTypeEnum<?> s = SymbolTypeEnum.byId(buf.readInt());
                StargateAddress sa = new StargateAddress((ByteBuf)buf);
                this.addresses.put(s, sa);
            }
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            if (this.dataType.admin()) {
                switch (this.action) {
                    case RENAME: {
                        StargateAbstractBaseBE gateTile = this.targetGatePos.getBlockEntity();
                        if (gateTile == null) {
                            JSG.logger.warn("Gate was null when trying to rename!", (Throwable)new Exception("Trying to rename null gate"));
                            return;
                        }
                        gateTile.renameStargatePos(this.name);
                        break;
                    }
                    case DIAL: {
                        StargateClassicBaseBE gateTile1 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile1 == null) {
                            return;
                        }
                        if (gateTile1.getStargateState().engaged()) {
                            gateTile1.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            break;
                        }
                        if (this.maxSymbols == -1) {
                            this.maxSymbols = Objects.requireNonNull(gateTile1).getMinimalSymbolsToDial(this.targetGatePos.getGateSymbolType(), this.targetGatePos);
                        }
                        gateTile1.dialAddress(this.addressToDial, this.maxSymbols - 1, true, this.dialType);
                        break;
                    }
                    case ABORT: {
                        StargateClassicBaseBE gateTile2 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile2 == null) {
                            return;
                        }
                        if (!gateTile2.getStargateState().dialing()) break;
                        gateTile2.abortDialingSequence();
                        break;
                    }
                    case TOGGLE_IRIS: {
                        StargateClassicBaseBE gateTile3 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile3 == null) {
                            return;
                        }
                        if (!gateTile3.hasIris()) break;
                        gateTile3.toggleIris();
                        break;
                    }
                    case GIVE_NOTEBOOK: {
                        ListTag pages = new ListTag();
                        for (SymbolTypeEnum<?> s : SymbolTypeRegistry.REGISTRY.values()) {
                            int originId;
                            StargateAddress address;
                            if (this.index == 1) {
                                if (this.addresses == null) continue;
                                address = this.addresses.get(s);
                                originId = StargateClassicBaseBE.getOriginId(null, this.targetGatePos.dimension, -1);
                            } else {
                                address = this.targetGatePos.getBlockEntity().getStargateAddress(s);
                                originId = this.targetGatePos.getBlockEntity().getOriginId();
                            }
                            CompoundTag pageCompound = PageNotebookItemFilled.getCompoundFromAddress((IAddress)address, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, PageNotebookItemFilled.getRegistryPathFromWorld(world, this.targetGatePos.gatePos), originId, NotebookPageSerialization.STARGATES);
                            PageNotebookItemFilled.setName(pageCompound, s.getId());
                            pages.add((Object)pageCompound);
                        }
                        ItemStack notebook = NotebookItem.createNotebook(pages);
                        if (!this.targetGatePos.getName().isEmpty()) {
                            notebook.m_41714_((Component)Component.m_237113_((String)this.targetGatePos.getName()));
                        } else {
                            notebook.m_41714_((Component)Component.m_237113_((String)BlockHelpers.blockPosToBetterString(this.targetGatePos.gatePos)));
                        }
                        player.m_36356_(notebook);
                        break;
                    }
                    case TELEPORT_TO_POS: {
                        TeleportHelper.teleportEntityToStargate((Entity)player, this.targetGatePos, true);
                        break;
                    }
                }
            }
        });
    }
}

