/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateTypeEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.NotImplementedException;

public class StateUpdateRequestToServer
extends PositionedPacket {
    StateTypeEnum stateType;

    public StateUpdateRequestToServer(BlockPos pos, StateTypeEnum stateType) {
        super(pos);
        this.stateType = stateType;
    }

    public StateUpdateRequestToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stateType.id);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.stateType = StateTypeEnum.byId(buf.readInt());
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            ServerLevel level = player.m_284548_();
            ctx.enqueueWork(() -> {
                StateProviderInterface te = (StateProviderInterface)level.m_7702_(this.pos);
                if (te != null) {
                    try {
                        State state = te.getState(this.stateType);
                        if (state == null) {
                            throw new NotImplementedException("State not implemented on " + te.getClass().getCanonicalName() + " : " + this.stateType.toString());
                        }
                        JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, this.stateType, state), player);
                    }
                    catch (Exception e) {
                        JSG.logger.error("Error while handling packet!", (Throwable)e);
                    }
                }
            });
        }
    }
}

