/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.packet.JSGPacket;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SetOpenTabToServer
extends JSGPacket {
    public int openTabId;

    public SetOpenTabToServer() {
    }

    public SetOpenTabToServer(int openTabId) {
        this.openTabId = openTabId;
    }

    public SetOpenTabToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.openTabId);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.openTabId = buf.readInt();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            AbstractContainerMenu container = player.f_36096_;
            if (container instanceof OpenTabHolderInterface) {
                OpenTabHolderInterface c = (OpenTabHolderInterface)container;
                c.setOpenTabId(this.openTabId);
            }
        });
    }
}

