/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.packet.JSGPacket;
import dev.tauri.jsg.packet.packets.AdminControllerGuiOpenToClient;
import dev.tauri.jsg.packet.packets.NotebookActionPacketToServer;
import dev.tauri.jsg.packet.packets.PageNotebookSetNameToServer;
import dev.tauri.jsg.packet.packets.PrinterButtonClickedToServer;
import dev.tauri.jsg.packet.packets.SetOpenTabToServer;
import dev.tauri.jsg.packet.packets.SoundPositionedPlayToClient;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.packet.packets.effect.StargateWormholeEffectToClient;
import dev.tauri.jsg.packet.packets.entry.EntryActionToServer;
import dev.tauri.jsg.packet.packets.linkable.GDOCodeKeyPressedToServer;
import dev.tauri.jsg.packet.packets.linkable.UniverseDialerActionPacketToServer;
import dev.tauri.jsg.packet.packets.stargate.DHDButtonClickedToServer;
import dev.tauri.jsg.packet.packets.stargate.SaveConfigToServer;
import dev.tauri.jsg.packet.packets.stargate.SaveIrisCodeToServer;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionAndRotationToClient;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionToClient;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionToServer;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class JSGPacketHandler {
    public static final String NETWORK_VERSION = "1.0";
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("jsg", "main")).clientAcceptedVersions(version -> Objects.equals(version, NETWORK_VERSION)).serverAcceptedVersions(version -> Objects.equals(version, NETWORK_VERSION)).networkProtocolVersion(() -> "1.0").simpleChannel();

    private JSGPacketHandler() {
    }

    public static void sendToServer(Object packet) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public static void sendToClient(Object packet, PacketDistributor.TargetPoint point) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> point), packet);
    }

    public static void sendTo(Object packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void init() {
        int index = -1;
        JSGPacketHandler.registerPacket(DHDButtonClickedToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, DHDButtonClickedToServer::new);
        JSGPacketHandler.registerPacket(StargateMotionToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, StargateMotionToServer::new);
        JSGPacketHandler.registerPacket(StateUpdateRequestToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, StateUpdateRequestToServer::new);
        JSGPacketHandler.registerPacket(SetOpenTabToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, SetOpenTabToServer::new);
        JSGPacketHandler.registerPacket(SaveIrisCodeToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, SaveIrisCodeToServer::new);
        JSGPacketHandler.registerPacket(SaveConfigToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, SaveConfigToServer::new);
        JSGPacketHandler.registerPacket(EntryActionToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, EntryActionToServer::new);
        JSGPacketHandler.registerPacket(UniverseDialerActionPacketToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, UniverseDialerActionPacketToServer::new);
        JSGPacketHandler.registerPacket(NotebookActionPacketToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, NotebookActionPacketToServer::new);
        JSGPacketHandler.registerPacket(PageNotebookSetNameToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, PageNotebookSetNameToServer::new);
        JSGPacketHandler.registerPacket(GDOCodeKeyPressedToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, GDOCodeKeyPressedToServer::new);
        JSGPacketHandler.registerPacket(PrinterButtonClickedToServer.class, ++index, NetworkDirection.PLAY_TO_SERVER, PrinterButtonClickedToServer::new);
        JSGPacketHandler.registerPacket(StateUpdatePacketToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, StateUpdatePacketToClient::new);
        JSGPacketHandler.registerPacket(SoundPositionedPlayToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, SoundPositionedPlayToClient::new);
        JSGPacketHandler.registerPacket(StargateMotionToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, StargateMotionToClient::new);
        JSGPacketHandler.registerPacket(AdminControllerGuiOpenToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, AdminControllerGuiOpenToClient::new);
        JSGPacketHandler.registerPacket(StargateMotionAndRotationToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, StargateMotionAndRotationToClient::new);
        JSGPacketHandler.registerPacket(StargateWormholeEffectToClient.class, ++index, NetworkDirection.PLAY_TO_CLIENT, StargateWormholeEffectToClient::new);
    }

    public static <MSG extends JSGPacket> void registerPacket(Class<MSG> clazz, int id, NetworkDirection direction, Function<FriendlyByteBuf, MSG> decoder) {
        try {
            INSTANCE.messageBuilder(clazz, id, direction).encoder(JSGPacket::toBytes).decoder(decoder).consumerNetworkThread(JSGPacket::handleSupplier).add();
        }
        catch (Exception e) {
            JSG.logger.error("Could not register packet " + id + ": ", (Throwable)e);
        }
    }
}

