/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.multistructure.mergehelper;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinMemberBE;
import dev.tauri.jsg.multistructure.mergehelper.StargateAbstractMergeHelper;
import dev.tauri.jsg.registry.BlockRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StargateOrlinMergeHelper
extends StargateAbstractMergeHelper {
    public StargateOrlinMergeHelper(@NotNull StargateAbstractBaseBE tileEntity) {
        super(tileEntity);
    }

    @Override
    public List<BlockPos> getRings() {
        return Arrays.asList(new BlockPos(1, 0, 0), new BlockPos(1, 1, 0), new BlockPos(1, 2, 0), new BlockPos(0, 2, 0), new BlockPos(-1, 2, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, 0, 0));
    }

    public void incrementMembersOpenCount() {
        if (!this.checkMergeState()) {
            return;
        }
        Level level = this.tileEntity.m_58904_();
        if (level == null) {
            return;
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.getBlocks().entrySet()) {
            BlockEntity tile = level.m_7702_(entry.getKey());
            if (!(tile instanceof StargateOrlinMemberBE)) continue;
            StargateOrlinMemberBE orlinMemberTile = (StargateOrlinMemberBE)tile;
            orlinMemberTile.incrementOpenCount();
        }
    }

    public int getMaxOpenCount() {
        int max = 0;
        Level level = this.tileEntity.m_58904_();
        if (level == null) {
            return 0;
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.getBlocks().entrySet()) {
            BlockEntity tile = level.m_7702_(entry.getKey());
            if (!(tile instanceof StargateOrlinMemberBE)) {
                return 0;
            }
            StargateOrlinMemberBE orlinMemberTile = (StargateOrlinMemberBE)tile;
            int open = orlinMemberTile.getOpenCount();
            if (open <= max) continue;
            max = open;
        }
        return max;
    }

    @Override
    public Block getRingBlock() {
        return (Block)BlockRegistry.STARGATE_ORLIN_MEMBER_BLOCK.get();
    }
}

