/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum ElementEnum {
    MILKYWAY_DHD("milkyway/dhd.obj", "milkyway/dhd.jpg", true),
    MILKYWAY_GATE("milkyway/gate.obj", "milkyway/gatering.jpg", true),
    MILKYWAY_RING("milkyway/ring.obj", "milkyway/gatering.jpg", true),
    MILKYWAY_CHEVRON_LIGHT("milkyway/chevron_light.obj", "milkyway/chevron.png", true),
    MILKYWAY_CHEVRON_FRAME("milkyway/chevron_frame.obj", "milkyway/gatering.jpg", true),
    MILKYWAY_CHEVRON_MOVING("milkyway/chevron_moving.obj", "milkyway/chevron.png", true),
    MILKYWAY_CHEVRON_BACK("milkyway/chevron_back.obj", "milkyway/gatering.jpg", true),
    ORLIN_GATE("orlin/orlin_gate.obj", "orlin/orlin_gate_base.jpg", false),
    ORLIN_GATE_BURNT("orlin/orlin_gate_burnt.obj", "orlin/orlin_gate_burnt.jpg", false),
    ORLIN_STAND("orlin/orlin_stand.obj", "orlin/orlin_stand_base.jpg", false),
    UNIVERSE_GATE("universe/universe_gate.obj", "universe/universe_gate.jpg", true),
    UNIVERSE_CHEVRON("universe/universe_chevron.obj", "universe/universe_chevron.png", true),
    UNIVERSE_SYMBOL("universe/universe_chevron.obj", "universe/universe_chevron_light.png", true),
    UNIVERSE_DIALER("universe/universe_dialer.obj", "universe/universe_dialer.jpg", true),
    UNIVERSE_DIALER_BROKEN("universe/universe_dialer.obj", "universe/universe_dialer_broken.jpg", true),
    PEGASUS_DHD("pegasus/dhd.obj", "pegasus/dhd.jpg", true),
    PEGASUS_GATE("pegasus/gate.obj", "pegasus/gatering.jpg", true),
    PEGASUS_RING("pegasus/ring_atlantis.obj", "pegasus/gatering.jpg", true),
    PEGASUS_CHEVRON_LIGHT("pegasus/chevron_light.obj", "pegasus/chevron.png", true),
    PEGASUS_CHEVRON_FRAME("pegasus/chevron_frame.obj", "pegasus/gatering.jpg", true),
    PEGASUS_CHEVRON_MOVING("pegasus/chevron_moving.obj", "pegasus/chevron.png", true),
    PEGASUS_CHEVRON_BACK("pegasus/chevron_back.obj", "pegasus/gatering.jpg", true),
    TOLLAN_GATE("tollan/gate.obj", "tollan/gate.jpg", false),
    TOLLAN_CHEVRON("tollan/chevron.obj", "tollan/gate.jpg", false),
    TOLLAN_CHEVRON_LIGHT("tollan/chevron_light.obj", "tollan/chevron.jpg", false),
    SHIELD("iris/shield.obj", "iris/shield.jpg", true),
    IRIS("iris/iris_blade.obj", "iris/iris_blade.jpg", true),
    GDO("iris/gdo.obj", "iris/gdo.png", false),
    ZPM("zpm/zpm.obj", "zpm/zpm0.png", false),
    ZPM_HUB("zpm/pg_zpm_hub.obj", "zpm/hub/pg_zpm_hub.jpg", false),
    ZPM_HUB_LIGHTS("zpm/pg_lights.obj", "zpm/hub/pg_lights0.jpg", false),
    ZPM_SLOT("zpm/slot.obj", "zpm/slot.png", false),
    DESTINY_COUNTDOWN("props/destiny/countdown.obj", "props/destiny/countdown.png", false),
    DESTINY_BEARING_OFF("props/destiny/bearing_light.obj", "props/destiny/bearing_light_off.png", false),
    DESTINY_BEARING_ON("props/destiny/bearing_light.obj", "props/destiny/bearing_light_on.png", false),
    DESTINY_BEARING_BODY("props/destiny/bearing_body.obj", "props/destiny/bearing_body.png", false),
    DESTINY_CHEVRON("props/destiny/floor_chevron.obj", "universe/universe_chevron.png", false),
    DESTINY_VENT_MOVING("props/destiny/vent_moving.obj", "props/destiny/vent_moving.png", false),
    DESTINY_VENT_HOLE("props/destiny/vent_hole.obj", "props/destiny/vent_hole.png", false);

    public final ResourceLocation model;
    public final Map<BiomeOverlayEnum, ResourceLocation> biomeTextureResourceMap = new HashMap<BiomeOverlayEnum, ResourceLocation>();
    private final List<BiomeOverlayEnum> nonExistingReported = new ArrayList<BiomeOverlayEnum>();

    private ElementEnum(String modelPath, String texturePath, boolean byOverlay) {
        this.model = ModelLoader.INSTANCE.getModelResource(modelPath);
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            if (!byOverlay) {
                this.biomeTextureResourceMap.put(biomeOverlay, TextureLoader.INSTANCE.getTextureResource(texturePath));
                continue;
            }
            String[] split = texturePath.split("\\.");
            this.biomeTextureResourceMap.put(biomeOverlay, TextureLoader.INSTANCE.getTextureResource(split[0] + biomeOverlay.getSuffix() + "." + split[1]));
        }
    }

    public void render(PoseStack ps) {
        ModelLoader.INSTANCE.getModel(this.model).render(ps);
    }

    public void render(PoseStack ps, boolean renderEmissive) {
        ModelLoader.INSTANCE.getModel(this.model).render(ps, renderEmissive);
    }

    public void bindTexture(BiomeOverlayEnum biomeOverlay) {
        ResourceLocation resourceLocation = this.biomeTextureResourceMap.get(biomeOverlay);
        this.bindTexture(biomeOverlay, resourceLocation);
    }

    private void bindTexture(BiomeOverlayEnum biomeOverlay, ResourceLocation resourceLocation) {
        if (!TextureLoader.INSTANCE.isTextureLoaded(resourceLocation)) {
            if (!this.nonExistingReported.contains(biomeOverlay)) {
                JSG.logger.error(String.valueOf((Object)this) + " tried to use BiomeOverlay " + String.valueOf(biomeOverlay) + " but it doesn't exist. (" + String.valueOf(resourceLocation) + ")");
                this.nonExistingReported.add(biomeOverlay);
            }
            resourceLocation = this.biomeTextureResourceMap.get(BiomeOverlayEnum.NORMAL);
        }
        TextureLoader.INSTANCE.getTexture(resourceLocation).bindTexture();
    }

    public void bindTextureAndRender(PoseStack ps) {
        this.bindTextureAndRender(BiomeOverlayEnum.NORMAL, ps);
    }

    public void bindTextureAndRender(BiomeOverlayEnum biomeOverlay, PoseStack ps) {
        this.bindTexture(biomeOverlay);
        this.render(ps);
    }
}

