/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.gdo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.helpers.ItemRenderingHelper;
import dev.tauri.jsg.item.linkable.HandHeldDeviceRenderer;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GarageDoorOpenerBEWLR
extends BlockEntityWithoutLevelRenderer {
    public GarageDoorOpenerBEWLR() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    @ParametersAreNonnullByDefault
    public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        OBJModel.source = bufferSource;
        HandHeldDeviceRenderer.currentStack = stack;
        HandHeldDeviceRenderer.source = bufferSource;
        HandHeldDeviceRenderer.light = light;
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        if (itemDisplayContext == ItemDisplayContext.FIXED) {
            stack.m_85836_();
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_85841_(1.0f, 1.0f, 1.0f);
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            stack.m_85841_(0.2f, 0.2f, 0.2f);
            stack.m_85836_();
            stack.m_85836_();
        } else {
            boolean thirdPerson;
            boolean mainHand = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            boolean bl = thirdPerson = itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            if (mainHand) {
                this.translateForRightHand(stack, !thirdPerson);
            } else {
                this.translateForLeftHand(stack, !thirdPerson);
            }
            if (thirdPerson) {
                if (mainHand) {
                    stack.m_252781_(Axis.f_252529_.m_252977_(-100.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(194.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(-36.0f));
                    stack.m_85837_(1.0, -3.0, -1.2);
                    stack.m_85841_(0.7f, 0.7f, 0.7f);
                } else {
                    stack.m_252781_(Axis.f_252529_.m_252977_(-100.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(163.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(33.0f));
                    stack.m_85837_(-2.5, -3.0, -1.2);
                    stack.m_85841_(0.75f, 0.75f, 0.75f);
                }
            }
        }
        ElementEnum.GDO.bindTextureAndRender(BiomeOverlayEnum.NORMAL, stack);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        double signal = 0.0;
        double battery = 0.0;
        CompoundTag compound = itemStack.m_41783_();
        if (compound != null) {
            if (compound.m_128441_("battery_percentage")) {
                battery = compound.m_128459_("battery_percentage");
                if (battery < 0.0) {
                    battery = 0.0;
                }
                if (battery > 1.0) {
                    battery = 1.0;
                }
            }
            if (compound.m_128441_("linked_gate_pos") && compound.m_128441_("signal_strength")) {
                signal = compound.m_128459_("signal_strength");
                if (signal < 0.0) {
                    signal = 0.0;
                }
                if (signal > 1.0) {
                    signal = 1.0;
                }
            }
        }
        stack.m_85836_();
        HandHeldDeviceRenderer.currentStack = stack;
        RenderSystem.enableDepthTest();
        stack.m_85837_(-2.07, 0.25, 0.19);
        stack.m_85841_(0.7f, 0.7f, 0.7f);
        stack.m_252880_(0.88f, 0.24f, 0.0f);
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/battery_background.png"));
        HandHeldDeviceRenderer.drawModalRectWithCustomSizedTexture(0.44f, 0.0f, 0.0f, 0.0f, 0.0f, 0.24f, 0.24f, 0.24f, 0.24f);
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/battery_inside.png"));
        float pixels = (float)(12.0 * battery + 2.0);
        HandHeldDeviceRenderer.drawModalRectWithCustomSizedTexture(0.44f, 0.0f, 0.0f, 0.0f, 0.0f, pixels / 16.0f * 0.24f, 0.24f, 0.24f, 0.24f);
        if (signal <= 0.0) {
            Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/signal_no_signal.png"));
            HandHeldDeviceRenderer.drawModalRectWithCustomSizedTexture(0.2f, 0.0f, 0.0f, 0.0f, 0.0f, 0.24f, 0.24f, 0.24f, 0.24f);
        } else {
            Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/signal_background.png"));
            pixels = 4.0f;
            if (signal > 0.25) {
                pixels = 7.0f;
            }
            if (signal > 0.5) {
                pixels = 10.0f;
            }
            if (signal > 0.75) {
                pixels = 16.0f;
            }
            HandHeldDeviceRenderer.drawModalRectWithCustomSizedTexture(0.2f, 0.0f, 0.0f, 0.0f, 0.0f, pixels / 16.0f * 0.24f, 0.24f, 0.24f, 0.24f);
        }
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(-0.75, 0.65, 0.19);
        String code = "";
        if (compound != null && compound.m_128441_("entered_code")) {
            code = compound.m_128461_("entered_code");
        }
        HandHeldDeviceRenderer.drawStringWithShadow(0.0f, 0.0f, "T-Mobile 5G", true, true);
        HandHeldDeviceRenderer.drawStringWithShadow(0.0f, -0.4f, "Code: " + code, false, true);
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85849_();
        RenderSystem.disableDepthTest();
    }

    private void translateForRightHand(PoseStack stack, boolean renderHand) {
        stack.m_252781_(Axis.f_252436_.m_252977_(-25.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(-30.0f));
        stack.m_85837_(-0.5, 0.25, -0.8);
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        stack.m_85836_();
        stack.m_85837_(0.0, 0.2, 0.5);
        stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
        if (renderHand) {
            HandHeldDeviceRenderer.renderArms(HumanoidArm.RIGHT, partialTicks);
        }
        stack.m_85836_();
        if (renderHand) {
            ItemRenderingHelper.applyBobbing(stack, partialTicks);
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(-60.0f));
        stack.m_85837_(0.0, 0.75, 1.0);
        stack.m_85841_(0.15f, 0.15f, 0.15f);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(57.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(-11.0f));
        stack.m_85837_(2.0, 0.0, -0.2);
    }

    private void translateForLeftHand(PoseStack stack, boolean renderHand) {
        stack.m_252781_(Axis.f_252529_.m_252977_(-50.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(50.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(130.0f));
        stack.m_85837_(-0.65, -0.4, -0.3);
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        stack.m_85836_();
        stack.m_85837_(0.0, 0.2, 0.5);
        stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
        if (renderHand) {
            HandHeldDeviceRenderer.renderArms(HumanoidArm.LEFT, partialTicks);
        }
        stack.m_85836_();
        if (renderHand) {
            ItemRenderingHelper.applyBobbing(stack, partialTicks);
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(-60.0f));
        stack.m_85837_(0.0, 0.75, 1.0);
        stack.m_85841_(0.15f, 0.15f, 0.15f);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(57.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(-11.0f));
        stack.m_85837_(2.0, 0.0, -0.2);
        stack.m_252781_(Axis.f_252529_.m_252977_(-35.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(195.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(6.0f));
        stack.m_85837_(0.0, -0.5, -1.2);
        stack.m_85841_(0.9f, 0.9f, 0.9f);
    }
}

