/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.helpers.ItemRenderingHelper;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Matrix4f;

public class HandHeldDeviceRenderer {
    public static PoseStack currentStack;
    public static MultiBufferSource source;
    public static int light;

    public static StargateAddressDynamic addrFromBytes(CompoundTag compound, String baseName) {
        if (compound == null || baseName == null) {
            return null;
        }
        SymbolTypeEnum<?> symbolType = SymbolTypeEnum.byId(compound.m_128461_(baseName + "_symbolType"));
        StargateAddressDynamic newAddress = new StargateAddressDynamic(symbolType);
        int addressLength = compound.m_128445_(baseName + "_addressLength");
        for (int i = 0; i < addressLength; ++i) {
            byte symbolId = compound.m_128445_(baseName + "_" + i);
            newAddress.addSymbol((SymbolInterface)symbolType.valueOf(symbolId));
        }
        return newAddress;
    }

    public static void drawStringWithShadow(float x, float y, String text, boolean active, boolean invertActiveColor) {
        HandHeldDeviceRenderer.drawStringWithShadow(x, y, text, active, invertActiveColor, false, false, EnumStargateState.IDLE);
    }

    public static void drawStringWithShadow(float x, float y, String text, boolean isActive, boolean invertActiveColor, boolean isAddress, boolean dialing, EnumStargateState stargateState) {
        int light = 0xF000F0;
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        currentStack.m_85836_();
        currentStack.m_252880_(x, y, 0.0f);
        currentStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        currentStack.m_85841_(0.015f, 0.015f, 0.015f);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (dialing) {
            red = 0.5f;
            green = 0.7f;
            blue = 1.0f;
        }
        if (isEngaged && dialing) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && dialing) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        int color = !isAddress ? (isActive ? (invertActiveColor ? 0 : 0xFFFFFF) : 24831) : new Color(red, green, blue, alpha).getRGB();
        Minecraft.m_91087_().f_91062_.m_271703_(text, -6.0f, 19.0f, color, false, currentStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, light);
        if (isActive) {
            currentStack.m_85837_(-0.4, 0.6, -0.1);
            Minecraft.m_91087_().f_91062_.m_271703_(text, -6.0f, 19.0f, color, false, currentStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, light);
        }
        currentStack.m_85849_();
    }

    public static void renderSymbol(int row, int col, SymbolInterface symbol, boolean dialing, boolean isActive, boolean engage, EnumStargateState stargateState) {
        RenderSystem.enableDepthTest();
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        float x = (float)col * 0.07f - 0.05f;
        float y = (float)(-row) * 0.2f - 0.16f;
        float scale = 0.5f;
        float w = 0.19f * scale;
        float h = 0.4f * scale;
        Texture.bindTextureWithMc(symbol.getIconResource());
        RenderSystem.enableBlend();
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (dialing && !isEngaged && !engage) {
            red = 0.5f;
            green = 0.7f;
            blue = 1.0f;
        }
        if (isEngaged && engage) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && engage) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        HandHeldDeviceRenderer.drawTexturedRect(x, y, 0.0f, w, h);
        float shadow = 0.008f;
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15f);
        HandHeldDeviceRenderer.drawTexturedRect(x + shadow, y - shadow, -0.01f, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTexturedRect(float x, float y, float z, float w, float h) {
        currentStack.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y, z).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + w, y, z).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + w, y + h, z).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y + h, z).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        currentStack.m_85849_();
    }

    public static void drawTexturedRectPercentage(float x, float y, float z, float w, float h) {
        currentStack.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y, z).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + w, y, z).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + w, y + h, z).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y + h, z).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        currentStack.m_85849_();
    }

    public static void drawModalRectWithCustomSizedTexture(float x, float y, float z, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        currentStack.m_85836_();
        currentStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y + height, z).m_7421_(u * f, (v + height) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y + height, z).m_7421_((u + width) * f, (v + height) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y, z).m_7421_((u + width) * f, v * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y, z).m_7421_(u * f, v * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        currentStack.m_85849_();
    }

    public static void renderArms(HumanoidArm handSide, float partialTicks) {
        currentStack.m_85836_();
        ItemRenderingHelper.applyBobbing(currentStack, partialTicks);
        ItemRenderingHelper.renderHand(currentStack, source, light, handSide);
        currentStack.m_85849_();
    }

    static {
        light = 1;
    }
}

