/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.oc2.methods;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.integration.ComputerDeviceProvider;
import dev.tauri.jsg.integration.oc2.OCDevices;
import dev.tauri.jsg.integration.oc2.methods.AbstractOCMethods;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.NearbyGate;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.codesender.ComputerCodeSender;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import li.cil.oc2.api.bus.device.object.Callback;
import net.minecraft.network.chat.Component;

public class StargateClassicOCMethods
extends AbstractOCMethods<StargateClassicBaseBE> {
    public StargateClassicOCMethods(ComputerDeviceProvider deviceTile) {
        super((StargateClassicBaseBE)deviceTile, OCDevices.STARGATE_CLASSIC);
    }

    @Callback(name="getOpenedTime")
    public Object[] getOpenedTime() {
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            String secondsString;
            int minutes;
            float openedSeconds = ((StargateClassicBaseBE)this.deviceTile).getOpenedSeconds();
            int seconds = (int)(openedSeconds - (float)(60 * (minutes = (int)Math.floor(openedSeconds / 60.0f))));
            String string = secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            if (openedSeconds > 0.0f) {
                return new Object[]{true, "stargate_time", "" + minutes, secondsString};
            }
            return new Object[]{false, "stargate_not_connected"};
        }
        return new Object[]{false, "stargate_not_connected"};
    }

    @Callback(name="toggleIris", description="function() -- close/open the iris/shield")
    public Object[] toggleIris() {
        if (((StargateClassicBaseBE)this.deviceTile).getIrisType() == EnumIrisType.NULL) {
            return new Object[]{false, "stargate_iris_missing", "Iris is not installed!"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getIrisMode() != EnumIrisMode.OC) {
            return new Object[]{false, "stargate_iris_error_mode", "Iris mode must be set to OC"};
        }
        boolean result = ((StargateClassicBaseBE)this.deviceTile).toggleIris();
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        if (!result && ((StargateClassicBaseBE)this.deviceTile).hasShieldIris() && ((StargateClassicBaseBE)this.deviceTile).isIrisOpened() && ((StargateClassicBaseBE)this.deviceTile).getEnergyStorage().getEnergyStored() < ((StargateClassicBaseBE)this.deviceTile).shieldKeepAlive * 3) {
            return new Object[]{false, "stargate_iris_not_power", "Not enough power to close shield"};
        }
        if (!result) {
            return new Object[]{false, "stargate_iris_busy", "Iris is busy"};
        }
        return new Object[]{true};
    }

    @Callback(name="getIrisState", description="function() -- get info about iris")
    public Object[] getIrisState() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisState().toString()};
    }

    @Callback(name="getIrisType", description="function() -- get info about iris")
    public Object[] getIrisType() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisType().toString()};
    }

    @Callback(name="getIrisDurability", description="function() -- get info about iris")
    public Object[] getIrisDurability() {
        ((StargateClassicBaseBE)this.deviceTile).updateIrisDurability();
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).irisDurability + "/" + ((StargateClassicBaseBE)this.deviceTile).irisMaxDurability, ((StargateClassicBaseBE)this.deviceTile).irisDurability, ((StargateClassicBaseBE)this.deviceTile).irisMaxDurability};
    }

    @Callback(name="sendMessageToIncoming", description="function(message:string) -- Sends message to last person, who sent code for iris")
    public Object[] sendMessageToIncoming(String msg) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            return new Object[]{null, "stargate_failure_not_engaged", "Stargate is not engaged"};
        }
        if (msg == null) {
            return new Object[]{false, "wrong_argument_type"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).codeSender != null && ((StargateClassicBaseBE)this.deviceTile).codeSender.canReceiveMessage()) {
            ((StargateClassicBaseBE)this.deviceTile).codeSender.sendMessage((Component)Component.m_237113_((String)msg));
            return new Object[]{true, "success"};
        }
        return new Object[]{false, "no_listener_available"};
    }

    @Callback(name="sendIrisCode", description="function(code:string) -- send code like GDO (should be only numbers)")
    public Object[] sendIrisCode(String code) {
        if (code == null) {
            return new Object[]{false, "invalid_method_format", "You must enter code!"};
        }
        StargatePos destinationPos = StargateNetwork.INSTANCE.getStargate(((StargateClassicBaseBE)this.deviceTile).getDialedAddress());
        if (destinationPos == null) {
            return new Object[]{false, "stargate_not_engaged"};
        }
        StargateAbstractBaseBE te = destinationPos.getBlockEntity();
        if (!(te instanceof StargateClassicBaseBE)) {
            return new Object[]{false, "invalid_target_gate"};
        }
        StargateClassicBaseBE classicTile = (StargateClassicBaseBE)te;
        classicTile.receiveIrisCode(new ComputerCodeSender(StargateNetwork.INSTANCE.getStargate(((StargateClassicBaseBE)this.deviceTile).getStargateAddress(SymbolTypeRegistry.MILKYWAY))), code);
        return new Object[]{true, "success"};
    }

    @Callback(name="abortDialing", description="function() - aborts dialing")
    public Object[] abortDialing() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().dialingComputer() || ((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            ((StargateClassicBaseBE)this.deviceTile).abortDialingSequence();
            ((StargateClassicBaseBE)this.deviceTile).m_6596_();
            return new Object[]{null, "stargate_aborting", "Aborting dialing"};
        }
        return new Object[]{null, "stargate_aborting_failed", "Aborting dialing failed"};
    }

    @Callback(name="engageGate", description="function() -- Tries to open the gate")
    public Object[] engageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            StargateOpenResult gateState = ((StargateClassicBaseBE)this.deviceTile).attemptOpenAndFail();
            if (gateState.ok()) {
                return new Object[]{"stargate_engage"};
            }
            return new Object[]{null, "stargate_failure_opening", "Stargate failed to open", gateState.toString()};
        }
        return new Object[]{null, "stargate_failure_busy", "Stargate is busy", ((StargateClassicBaseBE)this.deviceTile).getStargateState().toString()};
    }

    @Callback(name="disengageGate", description="function() -- Tries to close the gate")
    public Object[] disengageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            if (((StargateClassicBaseBE)this.deviceTile).getStargateState().initiating()) {
                ((StargateClassicBaseBE)this.deviceTile).attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{"stargate_disengage"};
            }
            return new Object[]{null, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{null, "stargate_failure_not_open", "The gate is closed"};
    }

    @Callback(name="engageSymbol", description="function(symbolName:string) -- Spins the ring to the given symbol and engages/locks it")
    public Object[] engageSymbol(Object symbol) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + String.valueOf((Object)((StargateClassicBaseBE)this.deviceTile).getStargateState())};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getDialedAddress().size() == 9) {
            return new Object[]{null, "stargate_failure_full", "Already dialed 9 chevrons"};
        }
        SymbolInterface targetSymbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbol);
        if (!targetSymbol.isValidForAddress() && !targetSymbol.origin()) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        ((StargateClassicBaseBE)this.deviceTile).addSymbolToAddressManual(targetSymbol, "oc_used");
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        return new Object[]{"stargate_spin"};
    }

    @Callback(name="dialAddress", description="function(address:string...) -- Spins the ring to the given symbol and engages/locks it")
    public final Object[] dialAddress(Object ... symbols) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + String.valueOf((Object)((StargateClassicBaseBE)this.deviceTile).getStargateState())};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getDialedAddress().size() > 0) {
            return new Object[]{null, "stargate_failure_not_empty", "Dialed address is not empty"};
        }
        if (symbols.length < 7) {
            return new Object[]{null, "input_address_malformed", "Input address is malformed"};
        }
        int maxSymbols = Math.min(symbols.length, 9);
        StargateAddressDynamic address = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        for (int i = 0; i < maxSymbols; ++i) {
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbols[i]);
            if (!symbol.isValidForAddress() && !symbol.origin()) {
                throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
            }
            address.addSymbol(symbol);
        }
        ((StargateClassicBaseBE)this.deviceTile).dialAddress(address, maxSymbols, false, EnumDialingType.NORMAL);
        return new Object[]{"dial_begun"};
    }

    @Callback(name="spinGate", description="function() -- Tries to spin mw gate")
    public Object[] spinGate(int time, boolean changeState) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getSymbolType() == SymbolTypeRegistry.PEGASUS) {
            return new Object[]{null, "stargate_not_supported", "Stargate type is not supported"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            if (time != 0) {
                ((StargateClassicBaseBE)this.deviceTile).spinRing(1, changeState, true, time);
                return new Object[]{null, "stargate_spin"};
            }
            return new Object[]{null, "stargate_failure_wrong_usage", "Time is 0"};
        }
        return new Object[]{null, "stargate_failure_not_idle", "The gate is not idle"};
    }

    @Callback(name="getCapacitorsInstalled", description="function() -- Returns capacitors count")
    public Integer getCapacitorsInstalled() {
        return ((StargateClassicBaseBE)this.deviceTile).isMerged() ? Integer.valueOf(((StargateClassicBaseBE)this.deviceTile).currentPowerTier - 1) : null;
    }

    @Callback(name="getGateType", description="function() -- Returns gate type")
    public String getGateType() {
        return ((StargateClassicBaseBE)this.deviceTile).isMerged() ? ((StargateClassicBaseBE)this.deviceTile).getStargateType().toString() : null;
    }

    @Callback(name="getSymbolType", description="function() -- Returns symbol type")
    public final String getSymbolType() {
        return ((StargateClassicBaseBE)this.deviceTile).isMerged() ? ((StargateClassicBaseBE)this.deviceTile).getSymbolType().getId() : null;
    }

    @Callback(name="getSymbolsMap", description="function() -- Returns map of symbols")
    public final List<String> getSymbolsMap() {
        return ((StargateClassicBaseBE)this.deviceTile).isMerged() ? Arrays.stream(((StargateClassicBaseBE)this.deviceTile).getSymbolType().getValues()).map(SymbolInterface::getEnglishName).toList() : null;
    }

    @Callback(name="getGateStatus", description="function() -- Returns gate status")
    public Object[] getGateStatus() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            return new Object[]{"open", ((StargateClassicBaseBE)this.deviceTile).getStargateState().initiating()};
        }
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getStargateState().toString().toLowerCase()};
    }

    @Callback(name="getSymbolsNeeded", description="function(address:string...) -- Returns symbols needed to dial an address")
    public Object[] getSymbolsNeeded(String ... symbols) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        for (String symbolObj : Arrays.stream(symbols).toList()) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        StargatePos pos = StargateNetwork.INSTANCE.getStargate(stargateAddress);
        if (pos == null) {
            return new Object[]{"gate_not_found"};
        }
        int symbolsCount = ((StargateClassicBaseBE)this.deviceTile).getMinimalSymbolsToDial(pos.getGateSymbolType(), pos);
        return new Object[]{true, symbolsCount};
    }

    @Callback(name="getEnergyRequiredToDial", description="function(address:string...) -- Returns energy needed to dial an address")
    public Object[] getEnergyRequiredToDial(String ... symbols) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        for (String symbolObj : Arrays.stream(symbols).toList()) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        EnergyRequiredToOperate energyRequired = ((StargateClassicBaseBE)this.deviceTile).getEnergyRequiredToDial(Objects.requireNonNull(StargateNetwork.INSTANCE.getStargate(stargateAddress)));
        HashMap<String, Constable> energyMap = new HashMap<String, Constable>(2);
        energyMap.put("open", Integer.valueOf(energyRequired.energyToOpen));
        energyMap.put("keepAlive", Integer.valueOf(energyRequired.keepAlive));
        energyMap.put("canOpen", Boolean.valueOf(((StargateClassicBaseBE)this.deviceTile).getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen));
        return new Object[]{energyMap};
    }

    @Callback(name="getNearbyGates", description="function(gateType:string, checkGateType:boolean, checkAddressAndEnergy:boolean) -- Returns nearby gates")
    public Object[] getNearbyGates(String gateType, boolean checkGateType, boolean checkAddressAndEnergy) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, false, "gate_not_merged", new HashMap()};
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        StargateTypeEnum symbolType = StargateTypeEnum.valueOf(gateType);
        for (NearbyGate g : ((StargateClassicBaseBE)this.deviceTile).getNearbyGates(symbolType, checkGateType, checkAddressAndEnergy)) {
            Map map2 = map.computeIfAbsent(g.address.getSymbolType().toString(), k -> new HashMap());
            map2.put(g.address.getNameList(), g.symbolsNeeded);
            map.put(g.gateType.toString(), map2);
        }
        return new Object[]{null, true, "success", map};
    }
}

