/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.oc2.methods;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tauri.jsg.integration.ComputerDeviceProvider;
import dev.tauri.jsg.integration.oc2.OCDevices;
import dev.tauri.jsg.integration.oc2.methods.IOCDevice;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import li.cil.oc2.api.bus.device.rpc.IEventSink;
import li.cil.oc2.api.bus.device.rpc.RPCEventSource;

public abstract class AbstractOCMethods<TILE extends ComputerDeviceProvider>
implements RPCEventSource,
IOCDevice {
    protected final TILE deviceTile;
    protected final OCDevices device;
    protected final UUID deviceUUID;
    protected final Map<IEventSink, UUID> computers = new HashMap<IEventSink, UUID>();

    public AbstractOCMethods(TILE deviceTile, OCDevices device) {
        this.deviceTile = deviceTile;
        this.device = device;
        this.deviceUUID = UUID.randomUUID();
    }

    @ParametersAreNonnullByDefault
    public void subscribe(IEventSink device, UUID deviceID) {
        this.computers.put(device, deviceID);
    }

    @ParametersAreNonnullByDefault
    public void unsubscribe(IEventSink device) {
        this.computers.remove(device);
    }

    @Override
    public void sendSignal(String eventName, Object ... objects) {
        JsonObject event = new JsonObject();
        event.addProperty("name", eventName);
        JsonArray data = new JsonArray();
        for (Object o : objects) {
            if (o instanceof Boolean) {
                Boolean bool = (Boolean)o;
                data.add(bool);
                continue;
            }
            if (o instanceof Double) {
                Double d = (Double)o;
                data.add((Number)d);
                continue;
            }
            if (o instanceof Float) {
                Float f = (Float)o;
                data.add((Number)f);
                continue;
            }
            if (o instanceof Integer) {
                Integer integer = (Integer)o;
                data.add((Number)integer);
                continue;
            }
            data.add(o.toString());
        }
        event.add("data", (JsonElement)data);
        for (Map.Entry entry : this.computers.entrySet()) {
            ((IEventSink)entry.getKey()).postEvent(this.deviceUUID, (JsonElement)event.deepCopy());
        }
    }
}

