/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.create;

import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Pair;
import dev.tauri.jsg.block.stargate.StargateClassicBaseBlock;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumStargateState;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TeleportTrackManager {
    public static void connectThroughStargate(ServerLevel level, BlockPos pos, BlockState state, Direction facing, Boolean forceEngaged) {
        boolean isEngaged;
        Direction.Axis portalTest;
        if (level == null || level.f_46443_) {
            return;
        }
        if (!(level.m_8055_(pos).m_60734_() instanceof TrackBlock)) {
            return;
        }
        TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        boolean isPortalTrack = shape.isPortal();
        Object object = shape == TrackShape.XO || shape == TrackShape.TW || shape == TrackShape.TE ? Direction.Axis.X : (portalTest = shape == TrackShape.ZO || shape == TrackShape.TN || shape == TrackShape.TS ? Direction.Axis.Z : null);
        if (portalTest == null) {
            return;
        }
        Direction facingOpposite = facing.m_122424_();
        BlockPos portalPos = pos.m_121945_(facingOpposite);
        BlockPos gatePos = portalPos.m_6625_(2);
        BlockState stargateBaseBlockState = level.m_8055_(gatePos);
        if (!(stargateBaseBlockState.m_60734_() instanceof StargateClassicBaseBlock)) {
            TeleportTrackManager.disconnectThisTrack(level, pos, state, portalTest);
            return;
        }
        BlockEntity tile = level.m_7702_(gatePos);
        if (!(tile instanceof StargateClassicBaseBE)) {
            TeleportTrackManager.disconnectThisTrack(level, pos, state, portalTest);
            return;
        }
        StargateClassicBaseBE outgoingGate = (StargateClassicBaseBE)tile;
        EnumStargateState stargateState = outgoingGate.getStargateState();
        boolean bl = forceEngaged != null ? forceEngaged : (isEngaged = stargateState.engaged() && outgoingGate.targetGatePos != null && outgoingGate.targetGatePos.getWorld() != null);
        if (outgoingGate.hasIris() && outgoingGate.getIrisState() != EnumIrisState.OPENED) {
            TeleportTrackManager.disconnectThisTrack(level, pos, state, portalTest);
            return;
        }
        if (isEngaged == isPortalTrack) {
            return;
        }
        boolean engagedInitiating = stargateState.initiating();
        TeleportTrackManager.disconnectThisTrack(level, pos, state, portalTest);
        if (isEngaged) {
            TrackBlockEntity tbe;
            BlockEntity otherBe;
            BlockFace otherTrack;
            BlockPos otherTrackPos;
            Pair<ServerLevel, BlockFace> otherSide = TeleportTrackManager.getOtherSide(outgoingGate, level);
            if (otherSide == null) {
                return;
            }
            ServerLevel otherLevel = (ServerLevel)otherSide.getFirst();
            BlockState existing = otherLevel.m_8055_(otherTrackPos = (otherTrack = (BlockFace)otherSide.getSecond()).getPos());
            if (!existing.m_247087_() && !(existing.m_60734_() instanceof TrackBlock)) {
                return;
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TrackBlock.SHAPE, (Comparable)TrackShape.asPortal((Direction)facingOpposite))).m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            otherLevel.m_7731_(otherTrackPos, (BlockState)((BlockState)state.m_61124_((Property)TrackBlock.SHAPE, (Comparable)TrackShape.asPortal((Direction)otherTrack.getFace()))).m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity be = engagedInitiating ? level.m_7702_(pos) : otherLevel.m_7702_(otherTrackPos);
            BlockEntity blockEntity = otherBe = !engagedInitiating ? level.m_7702_(pos) : otherLevel.m_7702_(otherTrackPos);
            if (be instanceof TrackBlockEntity) {
                tbe = (TrackBlockEntity)be;
                tbe.bind(level.m_46472_(), pos);
            }
            if (otherBe instanceof TrackBlockEntity) {
                tbe = (TrackBlockEntity)otherBe;
                tbe.bind(level.m_46472_(), pos);
            }
        }
    }

    private static void disconnectThisTrack(ServerLevel level, BlockPos pos, BlockState state, Direction.Axis axis) {
        if (!state.m_61138_((Property)TrackBlock.SHAPE) || !((TrackShape)state.m_61143_((Property)TrackBlock.SHAPE)).isPortal()) {
            return;
        }
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TrackBlock.SHAPE, (Comparable)(axis == Direction.Axis.X ? TrackShape.XO : TrackShape.ZO))).m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)be;
            tbe.boundLocation = null;
            tbe.m_6596_();
        }
    }

    private static Pair<ServerLevel, BlockFace> getOtherSide(@Nonnull StargateClassicBaseBE outgoingGate, ServerLevel level) {
        EnumStargateState stargateState = outgoingGate.getStargateState();
        if (!stargateState.engaged()) {
            return null;
        }
        if (outgoingGate.targetGatePos == null || outgoingGate.targetGatePos.getWorld() == null) {
            return null;
        }
        MinecraftServer minecraftserver = level.m_7654_();
        ServerLevel targetLevel = minecraftserver.m_129880_(outgoingGate.targetGatePos.getWorld().m_46472_());
        if (targetLevel == null) {
            return null;
        }
        BlockPos targetGatePos = outgoingGate.targetGatePos.gatePos;
        if (targetGatePos == null) {
            return null;
        }
        StargateAbstractBaseBE stargateAbstractBaseBE = outgoingGate.targetGatePos.getBlockEntity();
        if (!(stargateAbstractBaseBE instanceof StargateClassicBaseBE)) {
            return null;
        }
        StargateClassicBaseBE classicGate = (StargateClassicBaseBE)stargateAbstractBaseBE;
        if (classicGate.hasIris() && classicGate.getIrisState() != EnumIrisState.OPENED) {
            return null;
        }
        Direction targetFacing = classicGate.getFacing();
        Direction targetFacingVertical = classicGate.getFacingVertical();
        if (targetFacingVertical != Direction.SOUTH) {
            return null;
        }
        BlockPos targetTrackPos = targetGatePos.m_121955_(targetFacing.m_122436_()).m_6630_(2);
        return Pair.of((Object)targetLevel, (Object)new BlockFace(targetTrackPos, targetFacing.m_122424_()));
    }
}

