/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import com.mojang.blaze3d.platform.InputConstants;
import dev.tauri.jsg.item.JSGItem;
import dev.tauri.jsg.item.JSGSpawnEggItem;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.util.I18n;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.RegistryObject;

public class ItemHelper {
    public static RegistryObject<JSGSpawnEggItem> createSpawnEgg(String entityName, Supplier<? extends EntityType<? extends Mob>> entityType, int color1, int color2) {
        return ItemRegistry.REGISTER.register(entityName + "_spawn_egg", () -> new JSGSpawnEggItem(entityType, color1, color2, new Item.Properties()));
    }

    public static RegistryObject<JSGItem> createGenericItem(String name, RegistryObject<CreativeModeTab> tab) {
        return ItemRegistry.REGISTER.register(name, () -> new JSGItem(new Item.Properties(), tab));
    }

    public static RegistryObject<JSGItem> createFoodItem(String name, FoodProperties props, RegistryObject<CreativeModeTab> tab) {
        return ItemRegistry.REGISTER.register(name, () -> new JSGItem(new Item.Properties().m_41489_(props), tab));
    }

    public static RegistryObject<JSGItem> createGenericItemWithGenericTooltip(String name, RegistryObject<CreativeModeTab> tab) {
        return ItemHelper.createGenericItem(name, () -> List.of(Component.m_237115_((String)("item.jsg." + name + ".tooltip")).m_130940_(ChatFormatting.GRAY)), I18n.getAdvancedTooltip("item.jsg." + name + ".tooltip.extended", (i, line) -> line.m_130940_(ChatFormatting.GRAY)), tab);
    }

    public static RegistryObject<JSGItem> createGenericItem(String name, final @Nonnull TooltipFunction tooltip, final @Nullable I18n.AdvancedTooltip tooltipAdvanced, RegistryObject<CreativeModeTab> tab) {
        return ItemRegistry.REGISTER.register(name, () -> new JSGItem(new Item.Properties(), tab){

            @ParametersAreNonnullByDefault
            public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
                ItemHelper.applyToolTip(tooltip.run(), tooltipAdvanced, components, tooltipFlag);
            }
        });
    }

    public static RegistryObject<JSGItem> createDurabilityItem(String name, int durability, boolean shouldStayInCrafting, RegistryObject<CreativeModeTab> tab) {
        return ItemHelper.createDurabilityItem(name, durability, shouldStayInCrafting, 64, tab);
    }

    public static RegistryObject<JSGItem> createDurabilityItem(String name, int durability, boolean shouldStayInCrafting, int maxStack, RegistryObject<CreativeModeTab> tab) {
        return ItemHelper.createDurabilityItem(name, durability, shouldStayInCrafting, maxStack, null, null, tab);
    }

    public static RegistryObject<JSGItem> createDurabilityItemWithGenericTooltip(String name, int durability, boolean shouldStayInCrafting, int maxStack, RegistryObject<CreativeModeTab> tab) {
        return ItemHelper.createDurabilityItem(name, durability, shouldStayInCrafting, maxStack, List.of(Component.m_237115_((String)("item.jsg." + name + ".tooltip")).m_130940_(ChatFormatting.GRAY)), I18n.getAdvancedTooltip("item.jsg." + name + ".tooltip.extended", (i, line) -> line.m_130940_(ChatFormatting.GRAY)), tab);
    }

    public static void applyGenericToolTip(String itemName, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyToolTip(List.of(Component.m_237115_((String)("item.jsg." + itemName + ".tooltip")).m_130940_(ChatFormatting.GRAY)), I18n.getAdvancedTooltip("item.jsg." + itemName + ".tooltip.extended", (i, line) -> line.m_130940_(ChatFormatting.GRAY)), components, tooltipFlag);
    }

    public static void applyToolTip(@Nullable List<Component> tooltip, @Nullable I18n.AdvancedTooltip tooltipAdvanced, List<Component> components, TooltipFlag tooltipFlag) {
        if (tooltip == null) {
            return;
        }
        int key = 340;
        components.addAll(tooltip);
        boolean isKeyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
        if ((isKeyDown || tooltipFlag.m_7050_()) && tooltipAdvanced != null && tooltipAdvanced.formatLines() != null) {
            int width = tooltipAdvanced.getWidth() + 2;
            components.add((Component)Component.m_237113_((String)" ".repeat(width)).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.STRIKETHROUGH));
            components.addAll(tooltipAdvanced.formatLines());
            components.add((Component)Component.m_237113_((String)" ".repeat(width)).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.STRIKETHROUGH));
        } else if (tooltipAdvanced != null && tooltipAdvanced.formatLines() != null) {
            String text = Component.m_237115_((String)"tooltip.general.hold_shift").getString();
            text = text.replaceAll("%key%", InputConstants.Type.KEYSYM.m_84895_(key).m_84875_().getString());
            components.add((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public static RegistryObject<JSGItem> createDurabilityItem(String name, final int durability, final boolean shouldStayInCrafting, int maxStack, final @Nullable List<Component> tooltip, final @Nullable I18n.AdvancedTooltip tooltipAdvanced, RegistryObject<CreativeModeTab> tab) {
        return ItemRegistry.REGISTER.register(name, () -> {
            Item.Properties props = new Item.Properties().m_41487_(maxStack);
            if (durability > 0) {
                props.m_41503_(durability);
            }
            return new JSGItem(props, tab){

                @ParametersAreNonnullByDefault
                public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
                    return true;
                }

                public boolean isDamageable(ItemStack stack) {
                    return true;
                }

                @ParametersAreNonnullByDefault
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
                    ItemHelper.applyToolTip(tooltip, tooltipAdvanced, components, tooltipFlag);
                    components.add((Component)Component.m_237119_());
                    components.add((Component)Component.m_237113_((String)(String.format("%.2f", (double)(this.getMaxDamage(stack) - this.getDamage(stack)) / (double)this.getMaxDamage(stack) * 100.0) + "%")).m_130940_(ChatFormatting.GRAY));
                }

                @Nonnull
                public ItemStack m_7968_() {
                    ItemStack itemStack = new ItemStack((ItemLike)this);
                    this.setDamage(itemStack, 0);
                    return itemStack;
                }

                public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
                    return enchantment instanceof DigDurabilityEnchantment;
                }

                public int m_6473_() {
                    return 3;
                }

                public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
                    return shouldStayInCrafting;
                }

                public void setDamage(ItemStack stack, int damage) {
                    super.setDamage(stack, damage);
                    if (this.getMaxDamage(stack) <= damage) {
                        stack.m_41764_(0);
                    }
                }

                public int getMaxDamage(ItemStack stack) {
                    return durability;
                }

                @Nonnull
                public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
                    ItemStack it = itemStack.m_41777_();
                    it.m_41721_(itemStack.m_41773_() + 1);
                    return it;
                }
            };
        });
    }

    public static interface TooltipFunction {
        public List<Component> run();
    }
}

