/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.stargate;

import dev.tauri.jsg.config.IJSONConfigEntry;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class StargateDimensionConfigEntry
implements IJSONConfigEntry {
    public String name;
    public int distance;
    public ArrayList<String> groups;
    public Map<BiomeOverlayEnum, Integer> milkyWayOrigins;
    public double lightingBoltChance;
    public boolean isBlackHoleDim;

    public StargateDimensionConfigEntry(String name, int distance, ArrayList<String> groups) {
        this(name, distance, groups, 5.0E-4f, false);
    }

    public StargateDimensionConfigEntry(String name, int distance, ArrayList<String> groups, double lightingBoltChance, boolean isBlackHoleDim) {
        this(name, distance, groups, new HashMap<BiomeOverlayEnum, Integer>(), lightingBoltChance, isBlackHoleDim);
    }

    public StargateDimensionConfigEntry(String name, int distance, ArrayList<String> groups, @Nonnull Map<BiomeOverlayEnum, Integer> origins, double lightingBoltChance, boolean isBlackHoleDim) {
        this.name = name;
        this.distance = distance;
        this.groups = groups;
        this.milkyWayOrigins = origins;
        this.lightingBoltChance = lightingBoltChance;
        this.isBlackHoleDim = isBlackHoleDim;
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
    }

    public String toString() {
        if (!this.milkyWayOrigins.isEmpty()) {
            StringBuilder originIdsString = new StringBuilder("[");
            int i = 0;
            for (BiomeOverlayEnum k : this.milkyWayOrigins.keySet()) {
                ++i;
                if (k == null) {
                    originIdsString.append("[null]").append(": ").append("null");
                } else {
                    originIdsString.append(k).append(": ").append(this.milkyWayOrigins.get(k));
                }
                if (i >= this.milkyWayOrigins.size()) continue;
                originIdsString.append(", ");
            }
            originIdsString.append("]");
            return "[name=" + this.name + ", distance=" + this.distance + ", groups: '" + this.groups.toString() + "', milkyWayOrigins: '" + String.valueOf(originIdsString) + "']";
        }
        return "[name=" + this.name + ", distance=" + this.distance + ", groups: '" + this.groups.toString() + "']";
    }

    public boolean isGroupEqual(StargateDimensionConfigEntry other) {
        if (this.groups == null) {
            return false;
        }
        if (other.groups == null) {
            return false;
        }
        if (this.groups.isEmpty() || other.groups.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!other.groups.contains(this.groups.get(i))) continue;
            return true;
        }
        return this.groups.equals(other.groups);
    }

    @Override
    public String getId() {
        return this.name;
    }
}

