/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.ingame;

import dev.tauri.jsg.config.ingame.BlockConfigOptions;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.config.ingame.StargateConfigOptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class BlockConfigOptionRegistry {
    private static final Map<ResourceLocation, List<? extends BlockConfigOptions>> reg = new HashMap<ResourceLocation, List<? extends BlockConfigOptions>>();
    public static final ResourceLocation GATE_COMMON = BlockConfigOptionRegistry.register(new ResourceLocation("jsg", "gate_common"), StargateConfigOptions.COMMON);
    public static final ResourceLocation GATE_MILKYWAY = BlockConfigOptionRegistry.register(new ResourceLocation("jsg", "gate_milkyway"), StargateConfigOptions.MILKYWAY);
    public static final ResourceLocation GATE_PEGASUS = BlockConfigOptionRegistry.register(new ResourceLocation("jsg", "gate_pegasus"), StargateConfigOptions.PEGASUS);
    public static final ResourceLocation GATE_UNIVERSE = BlockConfigOptionRegistry.register(new ResourceLocation("jsg", "gate_universe"), StargateConfigOptions.UNIVERSE);
    public static final ResourceLocation GATE_TOLLAN = BlockConfigOptionRegistry.register(new ResourceLocation("jsg", "gate_tollan"), StargateConfigOptions.TOLLAN);

    public static ResourceLocation register(ResourceLocation blockType, List<? extends BlockConfigOptions> options) {
        if (!reg.containsKey(blockType)) {
            reg.put(blockType, options);
            return blockType;
        }
        throw new IllegalArgumentException("Config options have already been registered for blockType: \"%s\"".formatted(blockType));
    }

    public static Collection<? extends JSGConfigOption<?>> get(ResourceLocation blockType) {
        return reg.getOrDefault(blockType, List.of()).stream().map(BlockConfigOptions::get).toList();
    }
}

