/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.command.JSGAbstractCommand;
import dev.tauri.jsg.command.JSGCommand;
import dev.tauri.jsg.loader.OriginsLoader;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandImportOrigins
extends JSGAbstractCommand {
    public CommandImportOrigins() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Imports additional origins into config of the server (on singleplayer to config of the client) from file located in \"config/jsg/assets/loader/origins.json\"";
    }

    @Override
    @Nonnull
    public String getGeneralUsage() {
        return "originsimport [rewrite]";
    }

    @Override
    @Nonnull
    public String getName() {
        return "originsimport";
    }

    @Override
    @ParametersAreNonnullByDefault
    public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(Commands.m_82129_((String)"rewrite", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.execute((CommandSourceStack)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"rewrite")))).executes(ctx -> this.execute((CommandSourceStack)ctx.getSource(), false));
    }

    private int execute(CommandSourceStack sender, boolean rewrite) {
        if (OriginsLoader.loadOriginsToConfig(rewrite)) {
            this.baseCommand.sendSuccessMess(sender, "Origins imported!", new Object[0]);
            this.baseCommand.sendSuccessMess(sender, "Restart your minecraft to load new textures and models!!", new Object[0]);
        } else {
            this.baseCommand.sendErrorMess(sender, "Error occurred while attempting to import origins!", new Object[0]);
            this.baseCommand.sendErrorMess(sender, "Check the importing file", new Object[0]);
        }
        return 0;
    }
}

