/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.command.JSGAbstractCommand;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class JSGCommand {
    public final String commandName;
    protected final CommandHelp helpCommand;
    private final List<JSGAbstractCommand> subCommands = new LinkedList<JSGAbstractCommand>();
    private boolean isRegistered = false;
    public static final JSGCommand JSG_COMMAND_BASE = new JSGCommand("jsg");

    public JSGCommand(String commandName) {
        this.commandName = commandName;
        this.helpCommand = new CommandHelp(this);
    }

    public String getName() {
        return this.commandName;
    }

    private void assertNotRegistered() {
        if (this.isRegistered) {
            throw new UnsupportedOperationException("Tried to modify command when it's already registered!");
        }
    }

    public void registerSubCommand(JSGAbstractCommand command) {
        this.assertNotRegistered();
        this.subCommands.add(command);
    }

    public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder base = LiteralArgumentBuilder.literal((String)this.commandName);
        for (JSGAbstractCommand sub : this.subCommands) {
            base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(sub.register())).executes(ctx -> {
                this.showHelp((CommandSourceStack)ctx.getSource(), 1);
                return 0;
            });
        }
        dispatcher.register(base);
        JSG.logger.info("Successfully registered Commands!");
        this.isRegistered = true;
    }

    public String getTitle() {
        return "Just Stargate Mod";
    }

    public boolean canUseCommand(CommandSourceStack sender, int requiredPerms) {
        if (requiredPerms <= 0) {
            return true;
        }
        return sender.m_6761_(requiredPerms);
    }

    public void showHelp(CommandSourceStack sender, int page) {
        sender.m_243053_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.STRIKETHROUGH) + "      " + String.valueOf(ChatFormatting.RESET) + " " + String.valueOf(ChatFormatting.AQUA) + String.valueOf(ChatFormatting.BOLD) + this.getTitle() + " " + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.STRIKETHROUGH) + "      ")));
        ArrayList<JSGAbstractCommand> commands = new ArrayList<JSGAbstractCommand>();
        for (JSGAbstractCommand c : this.subCommands) {
            if (!this.canUseCommand(sender, c.getPermissions())) continue;
            commands.add(c);
        }
        int count = commands.size();
        int perPage = 10;
        int maxPage = (int)Math.ceil((double)count / 10.0);
        page = Math.max(1, Math.min(maxPage, page));
        int start = 10 * (page - 1);
        int end = 10 * page;
        int i = 0;
        for (JSGAbstractCommand c : commands) {
            if (++i <= start) continue;
            if (i > end) break;
            sender.m_243053_((Component)this.getCommandTextComponentForHelp(c));
        }
        MutableComponent back = Component.m_237113_((String)"\u00a73\u00a7l\u00a7m<--\u00a7r").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.getName() + " help " + (page - 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Previous page"))));
        MutableComponent next = Component.m_237113_((String)"\u00a73\u00a7l\u00a7m-->\u00a7r").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.getName() + " help " + (page + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Next page"))));
        MutableComponent arrows = Component.m_237113_((String)"       ");
        if (page - 1 > 0) {
            arrows.m_7220_((Component)back);
        } else {
            arrows.m_7220_((Component)Component.m_237113_((String)"\u00a78\u00a7l\u00a7m<--\u00a7r"));
        }
        arrows.m_7220_((Component)Component.m_237113_((String)(" \u00a77(" + page + "/" + maxPage + ")\u00a7r ")));
        if (page + 1 <= maxPage) {
            arrows.m_7220_((Component)next);
        } else {
            arrows.m_7220_((Component)Component.m_237113_((String)"\u00a78\u00a7l\u00a7m-->\u00a7r"));
        }
        sender.m_243053_((Component)arrows);
        sender.m_243053_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.STRIKETHROUGH) + "                                ")));
    }

    public MutableComponent getCommandTextComponentForHelp(JSGAbstractCommand cmd) {
        Style style = Style.f_131099_;
        HoverEvent he = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.BOLD) + "/" + this.getName() + " " + cmd.getGeneralUsage() + "\n" + String.valueOf(ChatFormatting.GRAY) + cmd.getDescription())));
        style = style.m_131144_(he);
        ClickEvent ce = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + this.getName() + " " + cmd.getName());
        style = style.m_131142_(ce);
        return Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_AQUA) + " /" + this.getName() + " " + cmd.getName())).m_6270_(style);
    }

    public void sendNoPerms(CommandSourceStack sender) {
        this.sendErrorMess(sender, "You don't have permissions to do that!", new Object[0]);
    }

    public void sendErrorMess(CommandSourceStack sender, String mess, Object ... param) {
        sender.m_243053_((Component)Component.m_237113_((String)" \u00a7c\u00a7l\u2718 \u00a77").m_7220_((Component)Component.m_237110_((String)mess, (Object[])param)));
    }

    public void sendSuccessMess(CommandSourceStack sender, String mess, Object ... params) {
        sender.m_243053_((Component)Component.m_237113_((String)" \u00a7a\u00a7l\u2714 \u00a77").m_7220_((Component)Component.m_237110_((String)mess, (Object[])params)));
    }

    public void sendInfoMess(CommandSourceStack sender, String mess, Object ... param) {
        sender.m_243053_((Component)Component.m_237113_((String)" \u00a73\u00a7l\u2502 \u00a77").m_7220_((Component)Component.m_237110_((String)mess, (Object[])param)));
    }

    public void sendUsageMess(CommandSourceStack sender, JSGAbstractCommand cmd) {
        sender.m_243053_((Component)Component.m_237113_((String)(" \u00a73\u00a7lUsage: \u00a77/" + this.getName() + " " + cmd.getGeneralUsage())));
    }

    public void sendRunningMess(CommandSourceStack sender, String mess, Object ... param) {
        sender.m_243053_((Component)Component.m_237113_((String)" \u00a76\u00a7l\u267a \u00a77").m_7220_((Component)Component.m_237110_((String)mess, (Object[])param)));
    }

    public static class CommandHelp
    extends JSGAbstractCommand {
        public CommandHelp(JSGCommand baseCommand) {
            super(baseCommand);
        }

        @Override
        public int getPermissions() {
            return 0;
        }

        @Override
        public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
            return command.then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                this.baseCommand.showHelp((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"));
                return 0;
            })).executes(ctx -> {
                this.baseCommand.showHelp((CommandSourceStack)ctx.getSource(), 1);
                return 0;
            });
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String getGeneralUsage() {
            return "help [page]";
        }

        @Override
        public String getDescription() {
            return "Shows this list";
        }
    }
}

