/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.capability;

import dev.tauri.jsg.power.general.ItemEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilityProvider
implements ICapabilityProvider {
    protected ItemEnergyStorage energyStorage;

    public ItemCapabilityProvider(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt, int maxEnergy) {
        this(stack, nbt, maxEnergy, false);
    }

    public ItemCapabilityProvider(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt, int maxEnergy, final boolean creative) {
        this.energyStorage = new ItemEnergyStorage(stack, maxEnergy){

            @Override
            public void setEnergyStored(int energy) {
                super.setEnergyStored(creative ? this.maxEnergyStored : energy);
            }

            @Override
            public int getEnergyStored() {
                if (creative) {
                    return this.maxEnergyStored;
                }
                return super.getEnergyStored();
            }

            @Override
            public int extractEnergy(int max, boolean simulate) {
                if (creative) {
                    this.setEnergyStored(this.maxEnergyStored);
                    return max;
                }
                return super.extractEnergy(max, simulate);
            }

            @Override
            public int receiveEnergy(int max, boolean simulate) {
                if (creative) {
                    this.setEnergyStored(this.maxEnergyStored);
                    return max;
                }
                return super.receiveEnergy(max, simulate);
            }

            @Override
            public boolean canReceive() {
                if (creative) {
                    return false;
                }
                return super.canReceive();
            }
        };
        if (nbt != null && nbt.m_128441_("Parent")) {
            this.backwardsCompat(nbt.m_128469_("Parent"));
        }
    }

    private void backwardsCompat(CompoundTag nbt) {
        if (nbt.m_128441_("energy")) {
            this.energyStorage.setEnergyStored(nbt.m_128451_("energy"));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return LazyOptional.empty();
    }
}

